/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedRunnable;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.results.FeatureOutputMetadata;
import org.anchoranalysis.feature.io.results.LabelledResultsCollector;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporterContext;
import org.anchoranalysis.plugin.image.task.feature.ThumbnailsWriter;
import org.anchoranalysis.plugin.image.task.feature.WriteWithGroups;

public class FeatureResultsAndThumbnails {
    private static final String OUTPUT_THUMBNAILS = "thumbnails";
    private final LabelledResultsCollector results;
    private ThumbnailsWriter thumbnails = new ThumbnailsWriter();
    private final OutputterChecked outputter;
    private final boolean calculationResultsNeeded;
    private final boolean thumbnailsEnabled;
    private final FeatureExporterContext context;
    private final FeatureOutputMetadata outputMetadata;

    public FeatureResultsAndThumbnails(FeatureOutputMetadata outputMetadata, FeatureExporterContext context) throws OutputWriteFailedException {
        this.outputMetadata = outputMetadata;
        this.results = new WriteWithGroups(outputMetadata.csvNonAggregated(), context::csvWriter, context.isRemoveNaNColumns());
        this.outputter = context.getContext().getOutputter().getChecked();
        MultiLevelOutputEnabled outputEnabled = context.getContext().getOutputter().getChecked().getOutputsEnabled();
        this.calculationResultsNeeded = outputMetadata.outputNames().calculationResultsNeeded(outputEnabled);
        this.thumbnailsEnabled = outputEnabled.isOutputEnabled(OUTPUT_THUMBNAILS);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CheckedSupplier<LabelledResultsVector, OperationFailedException> resultToAdd, CheckedSupplier<Optional<DisplayStack>, OperationFailedException> thumbnail) throws OperationFailedException {
        LabelledResultsVector labelledResult;
        ExecutionTimeRecorder recorder = this.context.getContext().getExecutionTimeRecorder();
        LabelledResultsVector labelledResultsVector = this.calculationResultsNeeded ? (LabelledResultsVector)recorder.recordExecutionTime("Calculate labelled results", () -> resultToAdd.get()) : (labelledResult = null);
        Optional thumbnailStack = this.thumbnailsEnabled ? (Optional)recorder.recordExecutionTime("Thumbnail for input", () -> thumbnail.get()) : Optional.empty();
        CheckedRunnable<OutputWriteFailedException> thumbnailOutputter = null;
        FeatureResultsAndThumbnails featureResultsAndThumbnails = this;
        synchronized (featureResultsAndThumbnails) {
            if (this.calculationResultsNeeded) {
                recorder.recordExecutionTime("Writing CSV", () -> this.results.add(labelledResult));
            }
            if (this.thumbnailsEnabled && thumbnailStack.isPresent()) {
                thumbnailOutputter = this.thumbnails.outputThumbnail((DisplayStack)thumbnailStack.get(), this.outputter, OUTPUT_THUMBNAILS);
            }
        }
        if (thumbnailOutputter != null) {
            try {
                recorder.recordExecutionTime("Writing thumbnail", () -> thumbnailOutputter.run());
            }
            catch (OutputWriteFailedException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGroupedResults(Optional<NamedFeatureStore<FeatureInputResults>> featuresAggregate, boolean includeGroups, Function<InputOutputContext, FeatureCSVWriterFactory> csvWriterCreator, InputOutputContext context) throws OutputWriteFailedException {
        FeatureResultsAndThumbnails featureResultsAndThumbnails = this;
        synchronized (featureResultsAndThumbnails) {
            this.results.flushAndClose(featuresAggregate, includeGroups, csvWriterCreator, this.outputMetadata, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAnyOpenIO() throws IOException {
        FeatureResultsAndThumbnails featureResultsAndThumbnails = this;
        synchronized (featureResultsAndThumbnails) {
            this.thumbnails.removeStoredThumbnails();
        }
    }
}

