/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedRunnable;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.OutputSequenceStackFactory;
import org.anchoranalysis.io.generator.sequence.OutputSequenceIncrementing;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

class ThumbnailsWriter {
    private OutputSequenceIncrementing<Stack> thumbnailOutputSequence;

    ThumbnailsWriter() {
    }

    public CheckedRunnable<OutputWriteFailedException> outputThumbnail(DisplayStack thumbnail, OutputterChecked outputter, String outputName) throws OperationFailedException {
        try {
            if (this.thumbnailOutputSequence == null) {
                OutputSequenceStackFactory factory = OutputSequenceStackFactory.always2D();
                this.thumbnailOutputSequence = factory.incrementingByOne(outputName, outputter);
            }
            return this.thumbnailOutputSequence.addAsynchronously((Object)thumbnail.deriveStack(false));
        }
        catch (OutputWriteFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeStoredThumbnails() {
        this.thumbnailOutputSequence = null;
    }
}

