/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature;

import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadataForOutput;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriter;
import org.anchoranalysis.feature.io.csv.results.LabelledResultsCSVWriterFactory;
import org.anchoranalysis.feature.io.results.FeatureOutputMetadata;
import org.anchoranalysis.feature.io.results.LabelledResultsCollector;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.io.results.group.GroupedResults;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.InputOutputContextSubdirectoryCache;

class WriteWithGroups
implements LabelledResultsCollector {
    private final LabelledResultsCSVWriter nonAggregatedResults;
    private final GroupedResults groupedResults = new GroupedResults();

    public WriteWithGroups(FeatureCSVMetadataForOutput outputMetadata, FeatureCSVWriterFactory writerCreator, boolean removeNaNColumns) throws OutputWriteFailedException {
        this.nonAggregatedResults = LabelledResultsCSVWriterFactory.create((FeatureCSVMetadataForOutput)outputMetadata, (FeatureCSVWriterFactory)writerCreator, Optional.of(arg_0 -> ((GroupedResults)this.groupedResults).addResultsFor(arg_0)), (boolean)removeNaNColumns);
        this.nonAggregatedResults.start();
    }

    public void add(LabelledResultsVector results) {
        this.nonAggregatedResults.add(results);
    }

    public void flushAndClose(Optional<NamedFeatureStore<FeatureInputResults>> featuresAggregate, boolean includeGroups, Function<InputOutputContext, FeatureCSVWriterFactory> csvWriterCreator, FeatureOutputMetadata outputMetadata, InputOutputContext context) throws OutputWriteFailedException {
        this.nonAggregatedResults.end();
        InputOutputContextSubdirectoryCache contextGroups = new InputOutputContextSubdirectoryCache(context.subdirectory("grouped", true), true);
        this.groupedResults.writeGroupResults(featuresAggregate, includeGroups, outputMetadata, metadata -> ((FeatureCSVWriterFactory)csvWriterCreator.apply(context)).create(metadata), contextGroups);
    }
}

