/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature.calculator;

import java.util.Optional;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.io.csv.metadata.RowLabels;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.CombineObjectsForFeatures;
import org.anchoranalysis.plugin.image.feature.object.ListWithThumbnails;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.InitializationWithEnergyStack;
import org.anchoranalysis.plugin.image.task.feature.calculator.LabelsForInput;
import org.anchoranalysis.plugin.image.thumbnail.ThumbnailBatch;

public class CalculateFeaturesForObjects<T extends FeatureInput> {
    private final CombineObjectsForFeatures<T> table;
    private final FeatureCalculatorMulti<T> calculator;
    private final InitializationWithEnergyStack initialization;
    private final boolean suppressErrors;
    private final FeatureCalculationContext<FeatureTableCalculator<T>> context;

    public CalculateFeaturesForObjects(CombineObjectsForFeatures<T> table, InitializationWithEnergyStack initialization, boolean suppressErrors, FeatureCalculationContext<FeatureTableCalculator<T>> context) throws OperationFailedException {
        this.table = table;
        this.calculator = CalculateFeaturesForObjects.startCalculator(context.getFeatureSource(), initialization, context.getLogger());
        this.suppressErrors = suppressErrors;
        this.initialization = initialization;
        this.context = context;
    }

    public void calculateForObjects(ObjectCollectionProvider provider, LabelsForInput labelsForInput) throws OperationFailedException {
        ObjectCollection objects = (ObjectCollection)this.context.getExecutionTimeRecorder().recordExecutionTime("Objects from provider", () -> CalculateFeaturesForObjects.objectsFromProvider(provider, this.initialization.getImage(), this.context.getLogger()));
        this.calculateForObjects(objects, this.initialization.getEnergyStack(), labelsForInput);
    }

    public void calculateForObjects(ObjectCollection objects, EnergyStack energyStack, LabelsForInput labelsForInput) throws OperationFailedException {
        try {
            ListWithThumbnails inputs = (ListWithThumbnails)this.context.getExecutionTimeRecorder().recordExecutionTime("Derive inputs start batch", () -> this.table.deriveInputsStartBatch(objects, energyStack, this.context.isThumbnailsEnabled(), this.context.getOperationContext()));
            this.calculateManyFeaturesInto(inputs, labelsForInput);
        }
        catch (CreateException | OperationFailedException e) {
            throw new OperationFailedException(e);
        }
    }

    private static ObjectCollection objectsFromProvider(ObjectCollectionProvider provider, ImageInitialization initialization, Logger logger) throws OperationFailedException {
        try {
            ObjectCollectionProvider providerDuplicated = (ObjectCollectionProvider)provider.duplicateBean();
            providerDuplicated.initializeRecursive((BeanInitialization)initialization, logger);
            return (ObjectCollection)providerDuplicated.get();
        }
        catch (ProvisionFailedException | InitializeException e) {
            throw new OperationFailedException(e);
        }
    }

    private void calculateManyFeaturesInto(ListWithThumbnails<T, ObjectCollection> listInputs, LabelsForInput labelsForInput) throws OperationFailedException {
        int i = 0;
        while (i < listInputs.size()) {
            int index = i++;
            FeatureInput input = (FeatureInput)listInputs.get(index);
            this.context.getResults().add((CheckedSupplier<LabelledResultsVector, OperationFailedException>)((CheckedSupplier)() -> this.calculateLabelledResults(input, listInputs, labelsForInput, index)), (CheckedSupplier<Optional<DisplayStack>, OperationFailedException>)((CheckedSupplier)() -> this.thumbnailForInput(input, listInputs.getThumbnailBatch(), this.context.isThumbnailsEnabled())));
        }
    }

    private LabelledResultsVector calculateLabelledResults(T input, ListWithThumbnails<T, ObjectCollection> listInputs, LabelsForInput labelsForInput, int index) throws OperationFailedException {
        try {
            this.context.getLogger().messageLogger().logFormatted("Calculating input %d of %d: %s", new Object[]{index + 1, listInputs.size(), input.toString()});
            ResultsVector results = this.calculator.calculate(input, this.context.getLogger().errorReporter(), this.suppressErrors);
            String objectIdentifier = this.table.uniqueIdentifierFor(input);
            RowLabels labels = labelsForInput.deriveLabels(objectIdentifier, this.context.getGroupGeneratorName(), index);
            return new LabelledResultsVector(labels, results);
        }
        catch (NamedFeatureCalculateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Optional<DisplayStack> thumbnailForInput(T input, Optional<ThumbnailBatch<ObjectCollection>> thumbnailBatch, boolean thumbnailsEnabled) throws OperationFailedException {
        if (thumbnailsEnabled && thumbnailBatch.isPresent()) {
            try {
                return Optional.of(thumbnailBatch.get().thumbnailFor((Object)this.table.objectsForThumbnail(input)));
            }
            catch (CreateException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    private static <T extends FeatureInput> FeatureCalculatorMulti<T> startCalculator(FeatureTableCalculator<T> calculator, InitializationWithEnergyStack initialization, Logger logger) throws OperationFailedException {
        try {
            calculator.start(initialization.getImage(), Optional.of(initialization.getEnergyStack()), logger);
        }
        catch (InitializeException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return calculator;
    }
}

