/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature.calculator;

import lombok.Generated;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.stack.Stack;

class ExtractFromProvider {
    public static EnergyStack extractStack(StackProvider stackEnergy, ImageInitialization initialization, Logger logger) throws OperationFailedException {
        try {
            StackProvider providerDuplicated = (StackProvider)stackEnergy.duplicateBean();
            providerDuplicated.initializeRecursive((BeanInitialization)initialization, logger);
            return new EnergyStack((Stack)providerDuplicated.get());
        }
        catch (ProvisionFailedException | InitializeException e) {
            throw new OperationFailedException(e);
        }
    }

    public static <T extends FeatureInput> Feature<T> extractFeature(FeatureListProvider<T> featureListProvider, String featureProviderName, FeatureRelatedInitialization initialization, Logger logger) throws FeatureCalculationException {
        try {
            featureListProvider.initializeRecursive((BeanInitialization)initialization, logger);
            FeatureList features = (FeatureList)featureListProvider.get();
            if (features.size() != 1) {
                throw new FeatureCalculationException(String.format("%s must return exactly one feature from its list. It currently returns %d", featureProviderName, features.size()));
            }
            return features.get(0);
        }
        catch (ProvisionFailedException | InitializeException e) {
            throw new FeatureCalculationException(e);
        }
    }

    @Generated
    private ExtractFromProvider() {
    }
}

