/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.labeller;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.io.csv.FeatureCSVWriter;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadata;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.image.task.bean.labeller.ImageLabeller;
import org.anchoranalysis.plugin.image.task.labeller.GroupedMultiplexOutputters;

public class SharedStateFilteredImageOutput<T> {
    private ImageLabeller<T> filter;
    private Outputter baseOutputter;
    private Optional<GroupedMultiplexOutputters> outputters;
    private Optional<FeatureCSVWriter> csvWriter;
    private T initialization;
    private boolean groupIdentifierForCalled = false;
    private final String outputNameImages;

    public SharedStateFilteredImageOutput(Outputter baseOutputter, ImageLabeller<T> filter, String outputNameMapping, String outputNameImages) throws CreateException {
        this.baseOutputter = baseOutputter;
        this.filter = filter;
        this.outputNameImages = outputNameImages;
        try {
            this.csvWriter = FeatureCSVWriter.create((FeatureCSVMetadata)new FeatureCSVMetadata(outputNameMapping, Arrays.asList("name", "group")), (Outputter)baseOutputter, (boolean)false);
        }
        catch (OutputWriteFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public synchronized void writeRow(String name, String groupIdentifier) {
        ArrayList<TypedValue> row = new ArrayList<TypedValue>();
        row.add(new TypedValue(name));
        row.add(new TypedValue(groupIdentifier));
        this.csvWriter.ifPresent(writer -> writer.addRow(row));
    }

    public synchronized void close() {
        this.csvWriter.ifPresent(FeatureCSVWriter::close);
    }

    public String labelFor(ProvidesStackInput input, InputOutputContext context) throws OperationFailedException {
        if (!this.groupIdentifierForCalled) {
            try {
                this.initFilterOutputters(input.pathForBindingRequired());
            }
            catch (InitializeException | InputReadFailedException e) {
                throw new OperationFailedException(e);
            }
            this.groupIdentifierForCalled = true;
        }
        return this.filter.labelFor(this.initialization, input, context);
    }

    public Optional<Outputter> getOutputterFor(String groupIdentifier) {
        return this.outputters.map(outputter -> outputter.getOutputterFor(groupIdentifier));
    }

    public T getFilterInitialization(Path pathForBinding) throws InitializeException {
        if (this.initialization == null) {
            this.initialization = this.filter.initialize(pathForBinding);
        }
        return this.initialization;
    }

    private void initFilterOutputters(Path pathForBinding) throws InitializeException {
        Optional outputterLabelsSubdirectory = this.baseOutputter.writerSelective().createSubdirectory(this.outputNameImages, false);
        this.outputters = OptionalUtilities.map((Optional)outputterLabelsSubdirectory, directory -> new GroupedMultiplexOutputters((Outputter)directory, this.filter.allLabels(this.getFilterInitialization(pathForBinding))));
    }
}

