/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.slice;

import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.io.imagej.convert.ConvertToImageProcessor;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.plugin.image.task.slice.FontSizeCalculator;
import org.anchoranalysis.plugin.image.task.slice.LabelToWrite;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point2d;

class MontageLabels {
    private static final RGBColor TEXT_COLOR = new RGBColor(255, 255, 0);
    private static final RGBColor FILL_COLOR_SUCCESSFUL = new RGBColor(0, 0, 255);
    private static final RGBColor FILL_COLOR_ERRORED = new RGBColor(255, 0, 0);
    private final ExecutionTimeRecorder executionTimeRecorder;
    private Point2d sumSizes = new Point2d();
    private List<LabelToWrite> labels = new LinkedList<LabelToWrite>();

    public synchronized void add(String text, BoundingBox box, boolean errored) {
        this.labels.add(new LabelToWrite(text, box, errored));
        this.sumSizes.add(box.extent().x(), box.extent().y());
    }

    public void flush(RGBStack stack, double ratioHeightForLabel, BoxAligner aligner) throws OperationFailedException {
        int fontSize = 0;
        try {
            for (int channel = 0; channel < 3; ++channel) {
                ImageProcessor processor = ConvertToImageProcessor.from((VoxelsUntyped)stack.getChannel(channel).voxels(), (int)0);
                if (!this.labels.isEmpty()) {
                    if (channel == 0 && !this.labels.isEmpty()) {
                        fontSize = this.calculateFontSize(processor, ratioHeightForLabel);
                    }
                    processor.setJustification(0);
                    processor.setColor(MontageLabels.extractColorComponent(TEXT_COLOR, channel));
                    processor.setFontSize(fontSize);
                }
                Color backgroundSuccessful = MontageLabels.extractColorComponent(FILL_COLOR_SUCCESSFUL, channel);
                Color backgroundErrored = MontageLabels.extractColorComponent(FILL_COLOR_ERRORED, channel);
                for (LabelToWrite label : this.labels) {
                    this.executionTimeRecorder.recordExecutionTime("Writing the label on a single image channel", () -> label.drawOnProcessor(processor, backgroundSuccessful, backgroundErrored, aligner));
                }
            }
            this.labels = null;
        }
        catch (ImageJConversionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private int calculateFontSize(ImageProcessor processor, double ratioHeightForLabel) {
        this.sumSizes.scale(1.0 / (double)this.labels.size());
        FontSizeCalculator calculator = new FontSizeCalculator(processor, this.labels.stream());
        return calculator.calculateOptimalFontSize(this.sumSizes, ratioHeightForLabel);
    }

    private static Color extractColorComponent(RGBColor color, int index) {
        int component = color.get(index);
        return new Color(component, component, component);
    }

    @Generated
    public MontageLabels(ExecutionTimeRecorder executionTimeRecorder) {
        this.executionTimeRecorder = executionTimeRecorder;
    }
}

