/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.stack;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalListParallel;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.math.arithmetic.Counter;
import org.anchoranalysis.plugin.image.task.bean.combine.Montage;
import org.anchoranalysis.plugin.image.task.size.SizeMapping;
import org.anchoranalysis.spatial.box.Extent;

public class ImageSizePrereader {
    private final ImageMetadataReader imageMetadataReader;
    private final StackReader stackReader;
    private final OperationContext context;

    public List<SizeMapping> imageSizesFor(List<StackSequenceInput> inputs) {
        this.context.getLogger().messageLogger().logFormatted("Prereading %d images in parallel across multiple cores", new Object[]{inputs.size()});
        Counter counter = new Counter();
        return FunctionalListParallel.mapToListOptional(inputs, ExperimentExecutionException.class, input -> this.sizeFromInput((StackSequenceInput)input, counter, inputs.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SizeMapping> sizeFromInput(StackSequenceInput input, Counter counter, int numberInputs) {
        int index;
        ImageSizePrereader imageSizePrereader;
        Optional<SizeMapping> optional;
        Optional size = Optional.empty();
        try {
            Path path = input.pathForBindingRequired();
            size = (Optional)this.context.getExecutionTimeRecorder().recordExecutionTime("Prereading image size", () -> this.scaledSizeFor(path));
            optional = size.map(extent -> new SizeMapping(path, (Extent)extent));
            imageSizePrereader = this;
        }
        catch (InputReadFailedException e) {
            int index2;
            ImageSizePrereader imageSizePrereader2;
            Optional<SizeMapping> optional2;
            try {
                this.context.getLogger().errorReporter().recordError(ImageSizePrereader.class, "Cannot determine input path: " + input.identifier());
                optional2 = Optional.empty();
                imageSizePrereader2 = this;
            }
            catch (Throwable throwable) {
                int index3;
                ImageSizePrereader imageSizePrereader3 = this;
                synchronized (imageSizePrereader3) {
                    index3 = counter.getCount();
                    counter.increment();
                }
                this.context.getLogger().messageLogger().logFormatted("Pre-reading image size (%d of %d) %s: %s", new Object[]{index3, numberInputs, size.isPresent() ? "succeeded" : "  failed", input.identifier()});
                throw throwable;
            }
            synchronized (imageSizePrereader2) {
                index2 = counter.getCount();
                counter.increment();
            }
            this.context.getLogger().messageLogger().logFormatted("Pre-reading image size (%d of %d) %s: %s", new Object[]{index2, numberInputs, size.isPresent() ? "succeeded" : "  failed", input.identifier()});
            return optional2;
        }
        synchronized (imageSizePrereader) {
            index = counter.getCount();
            counter.increment();
        }
        this.context.getLogger().messageLogger().logFormatted("Pre-reading image size (%d of %d) %s: %s", new Object[]{index, numberInputs, size.isPresent() ? "succeeded" : "  failed", input.identifier()});
        return optional;
    }

    private Optional<Extent> scaledSizeFor(Path imagePath) {
        try {
            ImageMetadata metadata = this.imageMetadataReader.openFile(imagePath, this.stackReader, this.context);
            return Optional.of(metadata.getDimensions().extent().flattenZ());
        }
        catch (Exception e) {
            this.context.getLogger().errorReporter().recordError(Montage.class, (Throwable)new ExperimentExecutionException("Cannot read the image-metadata for file at: " + String.valueOf(imagePath), (Throwable)e));
            return Optional.empty();
        }
    }

    @Generated
    public ImageSizePrereader(ImageMetadataReader imageMetadataReader, StackReader stackReader, OperationContext context) {
        this.imageMetadataReader = imageMetadataReader;
        this.stackReader = stackReader;
        this.context = context;
    }
}

