/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.blur;

import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.voxel.VoxelsUntyped;

public abstract class BlurStrategy
extends AnchorBean<BlurStrategy> {
    @BeanField
    @Positive
    private double sigma = 3.0;
    @BeanField
    private boolean sigmaInMeters = false;

    public abstract void blur(VoxelsUntyped var1, Dimensions var2, MessageLogger var3) throws OperationFailedException;

    protected double calculateSigma(Dimensions dimensions, MessageLogger logger) throws OperationFailedException {
        double sigmaToUse = this.sigma;
        if (this.sigmaInMeters) {
            if (dimensions.unitConvert().isPresent()) {
                sigmaToUse = ((UnitConverter)dimensions.unitConvert().get()).fromPhysicalDistance(this.sigma);
                logger.logFormatted("Converted sigmaInMeters=%f into sigma=%f", new Object[]{this.sigma, sigmaToUse});
            } else {
                throw new OperationFailedException("Sigma is specified in meters, but no image-resolution is present");
            }
        }
        if (sigmaToUse > (double)dimensions.x() || sigmaToUse > (double)dimensions.y()) {
            throw new OperationFailedException("The calculated sigma is FAR TOO LARGE. It is larger than the entire channel it is applied to");
        }
        return sigmaToUse;
    }

    @Generated
    public double getSigma() {
        return this.sigma;
    }

    @Generated
    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    @Generated
    public boolean isSigmaInMeters() {
        return this.sigmaInMeters;
    }

    @Generated
    public void setSigmaInMeters(boolean sigmaInMeters) {
        this.sigmaInMeters = sigmaInMeters;
    }
}

