/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.convert;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.image.bean.channel.ConvertChannelTo;
import org.anchoranalysis.image.core.channel.convert.ChannelConverter;
import org.anchoranalysis.image.core.channel.convert.ToUnsignedByteScaleByMinMaxValue;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;

public class ScaleByDictionary
extends ConvertChannelTo<UnsignedByteBuffer> {
    @BeanField
    private DictionaryProvider dictionary;
    @BeanField
    private String keyLower;
    @BeanField
    private String keyUpper;
    @BeanField
    private double scaleLower;
    @BeanField
    private double scaleUpper;

    public ChannelConverter<UnsignedByteBuffer> createConverter() throws CreateException {
        try {
            Dictionary dictionaryCreated = (Dictionary)this.dictionary.get();
            int min = ScaleByDictionary.getScaled(dictionaryCreated, this.keyLower, this.scaleLower);
            int max = ScaleByDictionary.getScaled(dictionaryCreated, this.keyUpper, this.scaleUpper);
            this.getLogger().messageLogger().logFormatted("ChannelConverter: scale with min=%d max=%d%n", new Object[]{min, max});
            return new ToUnsignedByteScaleByMinMaxValue(min, max);
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private static int getScaled(Dictionary dictionary, String key, double scale) throws CreateException {
        if (!dictionary.containsKey(key)) {
            throw new CreateException(String.format("Parameters is missing key '%s'", key));
        }
        double val = dictionary.getAsDouble(key);
        return (int)Math.round(val * scale);
    }

    @Generated
    public DictionaryProvider getDictionary() {
        return this.dictionary;
    }

    @Generated
    public void setDictionary(DictionaryProvider dictionary) {
        this.dictionary = dictionary;
    }

    @Generated
    public String getKeyLower() {
        return this.keyLower;
    }

    @Generated
    public void setKeyLower(String keyLower) {
        this.keyLower = keyLower;
    }

    @Generated
    public String getKeyUpper() {
        return this.keyUpper;
    }

    @Generated
    public void setKeyUpper(String keyUpper) {
        this.keyUpper = keyUpper;
    }

    @Generated
    public double getScaleLower() {
        return this.scaleLower;
    }

    @Generated
    public void setScaleLower(double scaleLower) {
        this.scaleLower = scaleLower;
    }

    @Generated
    public double getScaleUpper() {
        return this.scaleUpper;
    }

    @Generated
    public void setScaleUpper(double scaleUpper) {
        this.scaleUpper = scaleUpper;
    }
}

