/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider;

import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.ProviderAsStack;
import org.anchoranalysis.image.core.stack.Stack;

public class FromStack
extends ChannelProvider {
    @BeanField
    private int channelIndex = 0;
    @BeanField
    @AllowEmpty
    private String stackProviderID;
    @BeanField
    @OptionalBean
    private ProviderAsStack stack;
    private Channel channel;

    public FromStack(ProviderAsStack stack) {
        this.stack = stack;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.stackProviderID.isEmpty() && this.stack == null) {
            throw new BeanMisconfiguredException("One of either stackProviderID or stack must be specified");
        }
        if (!this.stackProviderID.isEmpty() && this.stack != null) {
            throw new BeanMisconfiguredException("Only one of either stackProviderID or stack must be specified, but not both.");
        }
    }

    public Channel get() throws ProvisionFailedException {
        if (this.channel == null) {
            this.channel = this.stackFromSource().getChannel(this.channelIndex);
            if (this.channel == null) {
                throw new ProvisionFailedException(String.format("channel %d cannot be found in stack", this.channelIndex));
            }
        }
        return this.channel;
    }

    private Stack stackFromSource() throws ProvisionFailedException {
        if (this.stack != null) {
            return this.stack.getAsStack();
        }
        try {
            return (Stack)((ImageInitialization)this.getInitialization()).stacks().getException(this.stackProviderID);
        }
        catch (NamedProviderGetException e) {
            throw new ProvisionFailedException(e.summarize());
        }
        catch (InitializeException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    @Generated
    public FromStack() {
    }

    @Generated
    public int getChannelIndex() {
        return this.channelIndex;
    }

    @Generated
    public void setChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    @Generated
    public String getStackProviderID() {
        return this.stackProviderID;
    }

    @Generated
    public void setStackProviderID(String stackProviderID) {
        this.stackProviderID = stackProviderID;
    }

    @Generated
    public ProviderAsStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ProviderAsStack stack) {
        this.stack = stack;
    }
}

