/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.arithmetic;

import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.plugin.image.bean.channel.provider.UnaryWithValueBase;

public abstract class ArithmeticWithConstantBase
extends UnaryWithValueBase {
    private static final ChannelFactorySingleType FACTORY = new ChannelFactoryUnsignedByte();

    @Override
    public Channel createFromChannelWithConstant(Channel channel, double value) throws ProvisionFailedException {
        int constant = (int)value;
        Channel channelOut = FACTORY.createEmptyInitialised(channel.dimensions());
        IterateVoxelsAll.withTwoVoxelBuffers((Voxels)channel.voxels().any(), (Voxels)channelOut.voxels().any(), (buffer1, buffer2, offset) -> {
            int voxelVal = buffer1.getInt(offset);
            int result = this.performBinaryOperation(voxelVal, constant);
            buffer2.putInt(offset, ArithmeticWithConstantBase.cropValueToByteRange(result));
        });
        return channelOut;
    }

    protected abstract int performBinaryOperation(int var1, int var2);

    private static int cropValueToByteRange(int result) {
        if (result < 0) {
            return 0;
        }
        if (result > 255) {
            return 255;
        }
        return result;
    }
}

