/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.arithmetic;

import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProviderTernary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public class MeanThreeChannels
extends ChannelProviderTernary {
    protected Channel process(Channel channel1, Channel channel2, Channel channel3) throws ProvisionFailedException {
        this.checkDimensions(channel1, channel2, channel3);
        Channel channelOut = ChannelFactory.instance().create(channel1.dimensions(), (VoxelDataType)UnsignedByteVoxelType.INSTANCE);
        this.processVoxels((Voxels<UnsignedByteBuffer>)channelOut.voxels().asByte(), (Voxels<UnsignedByteBuffer>)channel1.voxels().asByte(), (Voxels<UnsignedByteBuffer>)channel2.voxels().asByte(), (Voxels<UnsignedByteBuffer>)channel3.voxels().asByte());
        return channelOut;
    }

    private void processVoxels(Voxels<UnsignedByteBuffer> voxelsOut, Voxels<UnsignedByteBuffer> voxelsIn1, Voxels<UnsignedByteBuffer> voxelsIn2, Voxels<UnsignedByteBuffer> voxelsIn3) {
        for (int z = 0; z < voxelsOut.extent().z(); ++z) {
            UnsignedByteBuffer in1 = (UnsignedByteBuffer)voxelsIn1.sliceBuffer(z);
            UnsignedByteBuffer in2 = (UnsignedByteBuffer)voxelsIn2.sliceBuffer(z);
            UnsignedByteBuffer in3 = (UnsignedByteBuffer)voxelsIn3.sliceBuffer(z);
            UnsignedByteBuffer out = (UnsignedByteBuffer)voxelsOut.sliceBuffer(z);
            while (in1.hasRemaining()) {
                int mean = (in1.getUnsigned() + in2.getUnsigned() + in3.getUnsigned()) / 3;
                out.putUnsigned(mean);
            }
            assert (!in2.hasRemaining());
            assert (!in3.hasRemaining());
            assert (!out.hasRemaining());
        }
    }

    private void checkDimensions(Channel channel1, Channel channel2, Channel channel3) throws ProvisionFailedException {
        if (!channel1.dimensions().equals((Object)channel2.dimensions())) {
            throw new ProvisionFailedException("Dimensions of channels do not match");
        }
        if (!channel2.dimensions().equals((Object)channel3.dimensions())) {
            throw new ProvisionFailedException("Dimensions of channels do not match");
        }
    }
}

