/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.arithmetic;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.IterateVoxelsMask;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.plugin.image.bean.channel.provider.mask.UnaryWithMaskBase;

public class SubtractMean
extends UnaryWithMaskBase {
    @BeanField
    private boolean subtractFromMaskOnly = true;

    @Override
    protected Channel createFromMaskedChannel(Channel channel, Mask mask) {
        Voxels voxelsIntensity = channel.voxels().asByte();
        double mean = this.calculateMean((Voxels<UnsignedByteBuffer>)voxelsIntensity, mask);
        int meanRounded = (int)Math.round(mean);
        if (this.subtractFromMaskOnly) {
            this.subtractMeanMask((Voxels<UnsignedByteBuffer>)voxelsIntensity, mask, meanRounded);
        } else {
            this.subtractMeanAll((Voxels<UnsignedByteBuffer>)voxelsIntensity, meanRounded);
        }
        return channel;
    }

    private double calculateMean(Voxels<UnsignedByteBuffer> voxelsIntensity, Mask mask) {
        return IterateVoxelsMask.calculateRunningSum((Mask)mask, voxelsIntensity).mean(0.0);
    }

    private void subtractMeanMask(Voxels<UnsignedByteBuffer> voxelsIntensity, Mask mask, int mean) {
        IterateVoxelsMask.withBuffer((Mask)mask, voxelsIntensity, (point, buffer, offset) -> SubtractMean.processPoint(buffer, offset, mean));
    }

    private void subtractMeanAll(Voxels<UnsignedByteBuffer> voxelsIntensity, int mean) {
        IterateVoxelsAll.withBuffer(voxelsIntensity, (point, buffer, offset) -> SubtractMean.processPoint(buffer, offset, mean));
    }

    private static void processPoint(UnsignedByteBuffer buffer, int offset, int mean) {
        int intensity = buffer.getUnsigned(offset);
        int intensitySubtracted = intensity - mean;
        if (intensitySubtracted < 0) {
            intensitySubtracted = 0;
        }
        buffer.putUnsigned(offset, intensitySubtracted);
    }

    @Generated
    public boolean isSubtractFromMaskOnly() {
        return this.subtractFromMaskOnly;
    }

    @Generated
    public void setSubtractFromMaskOnly(boolean subtractFromMaskOnly) {
        this.subtractFromMaskOnly = subtractFromMaskOnly;
    }
}

