/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.assign;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.match.MatcherIntersectionHelper;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class AssignFromIntersectingObjects
extends ChannelProviderUnary {
    @BeanField
    private ObjectCollectionProvider objectsSource;
    @BeanField
    private ObjectCollectionProvider objectsTarget;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        ObjectCollection source = (ObjectCollection)this.objectsSource.get();
        ObjectCollection target = (ObjectCollection)this.objectsTarget.get();
        VoxelsExtracter extracter = channel.extract();
        AssignFromIntersectingObjects.streamIntersectingObjects(source, target).forEach(pair -> channel.assignValue(AssignFromIntersectingObjects.getValueForObject(extracter, (ObjectMask)pair._1())).toObject((ObjectMask)pair._2()));
        return channel;
    }

    private static Stream<Tuple2<ObjectMask, ObjectMask>> streamIntersectingObjects(ObjectCollection source, ObjectCollection target) {
        List<MatchedObject> matchList = MatcherIntersectionHelper.matchIntersectingObjects(source, target);
        return matchList.stream().map(owm -> Tuple.of((Object)owm.getSource(), (Object)AssignFromIntersectingObjects.selectBestMatch(owm.getSource(), owm.getMatches())));
    }

    private static ObjectMask selectBestMatch(ObjectMask source, ObjectCollection matches) {
        assert (matches.size() > 0);
        if (matches.size() == 1) {
            return matches.get(0);
        }
        int maxIntersection = -1;
        ObjectMask mostIntersecting = null;
        for (ObjectMask object : matches) {
            int intersectingVoxels = source.countIntersectingVoxels(object);
            if (intersectingVoxels <= maxIntersection) continue;
            mostIntersecting = object;
            maxIntersection = intersectingVoxels;
        }
        return mostIntersecting;
    }

    private static int getValueForObject(VoxelsExtracter<?> extracter, ObjectMask object) {
        return extracter.voxel((ReadableTuple3i)object.findArbitraryOnVoxel().orElseThrow(AnchorImpossibleSituationException::new));
    }

    @Generated
    public ObjectCollectionProvider getObjectsSource() {
        return this.objectsSource;
    }

    @Generated
    public void setObjectsSource(ObjectCollectionProvider objectsSource) {
        this.objectsSource = objectsSource;
    }

    @Generated
    public ObjectCollectionProvider getObjectsTarget() {
        return this.objectsTarget;
    }

    @Generated
    public void setObjectsTarget(ObjectCollectionProvider objectsTarget) {
        this.objectsTarget = objectsTarget;
    }
}

