/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.gradient;

import java.nio.FloatBuffer;
import lombok.Generated;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.convert.imglib2.ConvertToImg;

class GradientCalculator {
    private final boolean[] dimensions;
    private final float scaleFactor;
    private final int addSum;
    private boolean centralDifference = false;
    private boolean norm = true;

    public void gradient(VoxelsUntyped signalIn, Voxels<FloatBuffer> gradientOut) {
        this.gradientImgLib2(ConvertToImg.from((VoxelsUntyped)signalIn), (Img<FloatType>)ConvertToImg.fromFloat(gradientOut));
    }

    private void gradientImgLib2(Img<? extends RealType<?>> input, Img<FloatType> output) {
        Cursor in = input.localizingCursor();
        RandomAccess oc = output.randomAccess();
        OutOfBounds ra = Views.extendMirrorDouble(input).randomAccess();
        while (in.hasNext()) {
            in.fwd();
            ra.setPosition((Localizable)in);
            for (int i = 0; i < input.numDimensions(); ++i) {
                oc.setPosition(in.getLongPosition(i), i);
            }
            double diffSum = this.processDimensions(ra, input.numDimensions(), ((RealType)in.get()).getRealFloat());
            ((FloatType)oc.get()).set(this.calculateOutputPixel(diffSum));
        }
    }

    private double processDimensions(OutOfBounds<? extends RealType<?>> ra, int numDims, float central) {
        double diffSum = 0.0;
        for (int i = 0; i < numDims; ++i) {
            if (!this.dimensions[i]) continue;
            ra.fwd(i);
            float diff = central - ((RealType)ra.get()).getRealFloat();
            ra.bck(i);
            if (this.centralDifference) {
                ra.bck(i);
                diff += ((RealType)ra.get()).getRealFloat();
                ra.fwd(i);
            }
            if (this.norm) {
                diffSum += Math.pow(diff, 2.0);
                continue;
            }
            diffSum += (double)diff;
        }
        return diffSum;
    }

    private float calculateOutputPixel(double diffSum) {
        float diffOut = (float)this.maybeNorm(diffSum);
        return diffOut * this.scaleFactor + (float)this.addSum;
    }

    private double maybeNorm(double diffSum) {
        if (this.norm) {
            return Math.sqrt(diffSum);
        }
        return diffSum;
    }

    @Generated
    public GradientCalculator(boolean[] dimensions, float scaleFactor, int addSum) {
        this.dimensions = dimensions;
        this.scaleFactor = scaleFactor;
        this.addSum = addSum;
    }

    @Generated
    public boolean isCentralDifference() {
        return this.centralDifference;
    }

    @Generated
    public void setCentralDifference(boolean centralDifference) {
        this.centralDifference = centralDifference;
    }

    @Generated
    public boolean isNorm() {
        return this.norm;
    }

    @Generated
    public void setNorm(boolean norm) {
        this.norm = norm;
    }
}

