/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.intensity;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.statistics.HistogramFactory;
import org.anchoranalysis.math.histogram.Histogram;

public class QuantileStretch
extends ChannelProviderUnary {
    @BeanField
    private double quantile = 1.0;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        try {
            QuantileStretch.histogramStretch(channel, this.quantile);
            return channel;
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static void histogramStretch(Channel channel, double quantile) throws OperationFailedException {
        VoxelsUntyped voxels = channel.voxels();
        Histogram histogram = HistogramFactory.createFrom((VoxelsUntyped)voxels);
        double rangeMin = histogram.calculateMinimum();
        double rangeMax = histogram.quantile(quantile);
        if (rangeMax == rangeMin) {
            rangeMax = rangeMin + 1.0;
        }
        QuantileStretch.changeVoxels(voxels.any(), rangeMin, rangeMax);
    }

    private static void changeVoxels(Voxels<?> voxels, double rangeMin, double rangeMax) {
        double rangeMult = 255.0 / (rangeMax - rangeMin);
        IterateVoxelsAll.changeIntensity(voxels, value -> QuantileStretch.roundAndClamp(((double)value - rangeMin) * rangeMult));
    }

    private static int roundAndClamp(double value) {
        int rounded = (int)Math.round(value);
        if (rounded > 255) {
            return 255;
        }
        if (rounded < 0) {
            return 0;
        }
        return rounded;
    }

    @Generated
    public double getQuantile() {
        return this.quantile;
    }

    @Generated
    public void setQuantile(double quantile) {
        this.quantile = quantile;
    }
}

