/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.intensity;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class ScaleXY
extends ChannelProviderUnary {
    @BeanField
    private ScaleCalculator scaleCalculator;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        try {
            return ScaleXY.scale(channel, this.scaleCalculator, this.interpolator.voxelsResizer(), ((ImageInitialization)this.getInitialization()).suggestedSize(), this.getLogger().messageLogger());
        }
        catch (InitializeException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static Channel scale(Channel channel, ScaleCalculator scaleCalculator, VoxelsResizer resizer, Optional<ImageSizeSuggestion> suggestedSize, MessageLogger logger) throws ProvisionFailedException {
        try {
            ScaleXY.logResolution("Incoming", channel, logger);
            ScaleFactor scaleFactor = scaleCalculator.calculate(Optional.of(channel.dimensions()), suggestedSize);
            logger.logFormatted("Scale Factor: %s", new Object[]{scaleFactor.toString()});
            Channel channelOut = channel.scaleXY(scaleFactor, resizer);
            ScaleXY.logResolution("Outgoing", channelOut, logger);
            return channelOut;
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static void logResolution(String prefix, Channel channel, MessageLogger logger) {
        logger.logFormatted("%s image resolution: %s", new Object[]{prefix, ScaleXY.describeResolution(channel.resolution())});
    }

    private static String describeResolution(Optional<Resolution> resolution) {
        return resolution.map(Resolution::toString).orElse("undefined");
    }

    @Generated
    public ScaleCalculator getScaleCalculator() {
        return this.scaleCalculator;
    }

    @Generated
    public void setScaleCalculator(ScaleCalculator scaleCalculator) {
        this.scaleCalculator = scaleCalculator;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

