/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.dimensions.provider;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.AnchorCheckedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;

public class FromChannel
extends DimensionsProvider {
    @BeanField
    @AllowEmpty
    private String id = "";
    @BeanField
    @OptionalBean
    private ChannelProvider channel;

    public void onInitialization(ImageInitialization initialization) throws InitializeException {
        super.onInitialization((BeanInitialization)initialization);
        if (this.id.isEmpty() && this.channel == null) {
            throw new InitializeException("One of either channelProvider or id must be set");
        }
        if (!this.id.isEmpty() && this.channel != null) {
            throw new InitializeException("Only one -not both- of channelProvider and id should be set");
        }
    }

    public Dimensions get() throws ProvisionFailedException {
        return this.selectChannel().dimensions();
    }

    private Channel selectChannel() throws ProvisionFailedException {
        if (!this.id.isEmpty()) {
            return this.selectChannelForId(this.id);
        }
        return (Channel)this.channel.get();
    }

    private Channel selectChannelForId(String identifier) throws ProvisionFailedException {
        try {
            Optional combined = OptionalUtilities.orFlatSupplier((CheckedSupplier[])new CheckedSupplier[]{() -> this.channelDirectly(identifier), () -> this.channelFromStacks(identifier)});
            return (Channel)combined.orElseThrow(() -> FromChannel.provisionException(identifier));
        }
        catch (AnchorCheckedException e) {
            throw new ProvisionFailedException(String.format("A error occurred while retrieving channel `%s`", identifier), (Throwable)e);
        }
    }

    private Optional<Channel> channelDirectly(String identifier) throws NamedProviderGetException, InitializeException {
        return ((ImageInitialization)this.getInitialization()).channels().getOptional(identifier);
    }

    private Optional<Channel> channelFromStacks(String identifier) throws NamedProviderGetException, InitializeException {
        return ((ImageInitialization)this.getInitialization()).stacks().getOptional(identifier).map(stack -> stack.getChannel(0));
    }

    private static ProvisionFailedException provisionException(String identifier) {
        return new ProvisionFailedException(String.format("Failed to find either a channel or stack with id `%s`", identifier));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public ChannelProvider getChannel() {
        return this.channel;
    }

    @Generated
    public void setChannel(ChannelProvider channel) {
        this.channel = channel;
    }
}

