/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.histogram.threshold;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.CalculateLevel;
import org.anchoranalysis.math.histogram.Histogram;

public class Otsu
extends CalculateLevel {
    public int calculateLevel(Histogram histogram) throws OperationFailedException {
        long totalSum = histogram.calculateSum();
        long totalCount = histogram.getTotalCount();
        long runningSum = 0L;
        long runningCount = histogram.getCount(0);
        double bcvMax = Double.NEGATIVE_INFINITY;
        int thresholdChosen = 0;
        int minIntensity = histogram.calculateMinimum() + 1;
        int maxIntensity = histogram.calculateMaximum() - 1;
        for (int intensity = minIntensity; intensity <= maxIntensity; ++intensity) {
            double bcv = Otsu.betweenClassVariance(runningSum += (long)(intensity * histogram.getCount(intensity)), runningCount += (long)histogram.getCount(intensity), totalSum, totalCount);
            if (!(bcv >= bcvMax) || Double.isNaN(bcv)) continue;
            bcvMax = bcv;
            thresholdChosen = intensity;
        }
        return thresholdChosen;
    }

    private static double betweenClassVariance(long runningSum, long runningCount, long totalSum, long totalCount) {
        double denom = (double)runningCount * (double)(totalCount - runningCount);
        if (denom == 0.0) {
            return Double.NaN;
        }
        double num = (double)runningCount / (double)totalCount * (double)totalSum - (double)runningSum;
        return num * num / denom;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Otsu)) {
            return false;
        }
        Otsu other = (Otsu)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Otsu;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

