/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.MaskProviderUnary;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class ScaleXY
extends MaskProviderUnary {
    @BeanField
    private ScaleCalculator scaleCalculator;

    public Mask createFromMask(Mask mask) throws ProvisionFailedException {
        try {
            return ScaleXY.scale(mask, this.scaleCalculator, ((ImageInitialization)this.getInitialization()).suggestedSize());
        }
        catch (InitializeException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static Mask scale(Mask mask, ScaleCalculator scaleCalculator, Optional<ImageSizeSuggestion> suggestedSize) throws ProvisionFailedException {
        ScaleFactor scaleFactor;
        try {
            scaleFactor = scaleCalculator.calculate(Optional.of(mask.dimensions()), suggestedSize);
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
        if (scaleFactor.isNoScale()) {
            return mask;
        }
        return mask.scaleXY(scaleFactor);
    }

    @Generated
    public ScaleCalculator getScaleCalculator() {
        return this.scaleCalculator;
    }

    @Generated
    public void setScaleCalculator(ScaleCalculator scaleCalculator) {
        this.scaleCalculator = scaleCalculator;
    }
}

