/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider.morphological;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.MaskProviderUnary;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsEqualTo;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.PointRange;

public class FitBoxToOnVoxels
extends MaskProviderUnary {
    @BeanField
    private boolean slicesSeparately = false;

    public Mask createFromMask(Mask mask) throws ProvisionFailedException {
        if (this.slicesSeparately) {
            mask.extent().iterateOverZ(z -> {
                BoundingBox box = this.minimalBoxAroundMask((BinaryVoxels<UnsignedByteBuffer>)mask.extractSlice(z).binaryVoxels());
                mask.assignOn().toBox(box.shiftToZ(z));
            });
        } else {
            BoundingBox box = this.minimalBoxAroundMask((BinaryVoxels<UnsignedByteBuffer>)mask.binaryVoxels());
            mask.binaryVoxels().assignOn().toBox(box);
        }
        return mask;
    }

    private BoundingBox minimalBoxAroundMask(BinaryVoxels<UnsignedByteBuffer> voxels) throws ProvisionFailedException {
        PointRange pointRange = new PointRange();
        BinaryValuesByte binaryValues = voxels.binaryValues().asByte();
        IterateVoxelsEqualTo.equalToReusePoint((Voxels)voxels.voxels(), (byte)binaryValues.getOn(), arg_0 -> ((PointRange)pointRange).add(arg_0));
        try {
            return pointRange.toBoundingBox();
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    @Generated
    public boolean isSlicesSeparately() {
        return this.slicesSeparately;
    }

    @Generated
    public void setSlicesSeparately(boolean slicesSeparately) {
        this.slicesSeparately = slicesSeparately;
    }
}

