/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider.morphological;

import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.MaskProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public abstract class MorphologicalOperatorBase
extends MaskProviderUnary {
    @BeanField
    @OptionalBean
    private ChannelProvider backgroundChannelProvider;
    @BeanField
    @Positive
    private int iterations = 1;
    @BeanField
    private int minIntensityValue = 0;
    @BeanField
    private boolean suppress3D = false;

    protected abstract void applyMorphologicalOperation(Mask var1, boolean var2) throws ProvisionFailedException;

    public Mask createFromMask(Mask mask) throws ProvisionFailedException {
        this.applyMorphologicalOperation(mask, mask.dimensions().z() > 1 && !this.suppress3D);
        return mask;
    }

    protected Optional<Predicate<Point3i>> precondition() throws ProvisionFailedException {
        if (this.minIntensityValue > 0) {
            Voxels background = ((Channel)this.backgroundChannelProvider.get()).voxels().asByte();
            return Optional.of(point -> MorphologicalOperatorBase.intensityCondition((Voxels<UnsignedByteBuffer>)background, point, this.minIntensityValue));
        }
        return Optional.empty();
    }

    private static boolean intensityCondition(Voxels<UnsignedByteBuffer> voxels, Point3i point, int minIntensityValue) {
        return minIntensityValue == 0 || voxels.extract().voxel((ReadableTuple3i)point) >= minIntensityValue;
    }

    @Generated
    public ChannelProvider getBackgroundChannelProvider() {
        return this.backgroundChannelProvider;
    }

    @Generated
    public void setBackgroundChannelProvider(ChannelProvider backgroundChannelProvider) {
        this.backgroundChannelProvider = backgroundChannelProvider;
    }

    @Generated
    public int getIterations() {
        return this.iterations;
    }

    @Generated
    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Generated
    public int getMinIntensityValue() {
        return this.minIntensityValue;
    }

    @Generated
    public void setMinIntensityValue(int minIntensityValue) {
        this.minIntensityValue = minIntensityValue;
    }

    @Generated
    public boolean isSuppress3D() {
        return this.suppress3D;
    }

    @Generated
    public void setSuppress3D(boolean suppress3D) {
        this.suppress3D = suppress3D;
    }
}

