/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider.slice;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.bean.provider.MaskProviderUnary;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.mask.MaskFactory;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.plugin.image.bean.dimensions.provider.GuessDimensions;
import org.anchoranalysis.spatial.box.Extent;

public class RepeatSlice
extends MaskProviderUnary {
    @BeanField
    private DimensionsProvider dimensions = new GuessDimensions();
    @BeanField
    private int sliceIndex = 0;

    public Mask createFromMask(Mask mask) throws ProvisionFailedException {
        Dimensions dimensionsForOutput = (Dimensions)this.dimensions.get();
        Mask out = this.createEmptyMask(mask, dimensionsForOutput);
        UnsignedByteBuffer bufferSliceToRepeat = mask.sliceBuffer(this.sliceIndex);
        Extent extent = dimensionsForOutput.extent();
        extent.iterateOverZ(z -> RepeatSlice.copySliceInto(bufferSliceToRepeat, z, extent, out));
        return out;
    }

    private Mask createEmptyMask(Mask mask, Dimensions dimensionsForOutput) throws ProvisionFailedException {
        if (!mask.extent().equalsIgnoreZ(dimensionsForOutput.extent())) {
            throw new ProvisionFailedException("The slice does not have the same XY extent as specified in dimensions");
        }
        return MaskFactory.createMaskOff((Dimensions)dimensionsForOutput);
    }

    private static void copySliceInto(UnsignedByteBuffer bufferSliceToRepeat, int sliceIndexOut, Extent extent, Mask out) {
        UnsignedByteBuffer bufferOut = out.sliceBuffer(sliceIndexOut);
        extent.iterateOverXYOffset(offset -> bufferOut.putRaw(offset, bufferSliceToRepeat.getRaw(offset)));
    }

    @Generated
    public DimensionsProvider getDimensions() {
        return this.dimensions;
    }

    @Generated
    public void setDimensions(DimensionsProvider dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public int getSliceIndex() {
        return this.sliceIndex;
    }

    @Generated
    public void setSliceIndex(int sliceIndex) {
        this.sliceIndex = sliceIndex;
    }
}

