/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.independent;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterPredicate;

public class GreaterIntersectionWith
extends ObjectFilterPredicate {
    @BeanField
    private ObjectCollectionProvider objectsGreater;
    @BeanField
    private ObjectCollectionProvider objectsLesser;
    private ObjectCollection intersectionGreater;
    private ObjectCollection intersectionLesser;

    @Override
    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
        super.start(dimensions, objectsToFilter);
        try {
            this.intersectionGreater = (ObjectCollection)this.objectsGreater.get();
            this.intersectionLesser = (ObjectCollection)this.objectsLesser.get();
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected boolean precondition(ObjectCollection objectsToFilter) {
        return true;
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dimensions) throws OperationFailedException {
        int countLesser;
        int countGreater = GreaterIntersectionWith.countIntersectingVoxels(this.intersectionGreater, object);
        return countGreater >= (countLesser = GreaterIntersectionWith.countIntersectingVoxels(this.intersectionLesser, object));
    }

    @Override
    protected void end() throws OperationFailedException {
        this.intersectionGreater = null;
        this.intersectionLesser = null;
    }

    private static int countIntersectingVoxels(ObjectCollection objects, ObjectMask toIntersectWith) {
        int count = 0;
        for (ObjectMask other : objects) {
            count += other.countIntersectingVoxels(toIntersectWith);
        }
        return count;
    }

    @Generated
    public ObjectCollectionProvider getObjectsGreater() {
        return this.objectsGreater;
    }

    @Generated
    public void setObjectsGreater(ObjectCollectionProvider objectsGreater) {
        this.objectsGreater = objectsGreater;
    }

    @Generated
    public ObjectCollectionProvider getObjectsLesser() {
        return this.objectsLesser;
    }

    @Generated
    public void setObjectsLesser(ObjectCollectionProvider objectsLesser) {
        this.objectsLesser = objectsLesser;
    }
}

