/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.independent;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.unitvalue.distance.UnitValueDistance;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterPredicate;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.box.Extent;

public class IntensityGreaterEqualThan
extends ObjectFilterPredicate {
    @BeanField
    private ChannelProvider channel;
    @BeanField
    private UnitValueDistance threshold;
    private Voxels<?> voxels;

    @Override
    protected boolean precondition(ObjectCollection objectsToFilter) {
        return true;
    }

    @Override
    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
        Channel channelSingleRegion;
        try {
            channelSingleRegion = (Channel)this.channel.get();
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
        assert (channelSingleRegion != null);
        this.voxels = channelSingleRegion.voxels().any();
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dimensions) throws OperationFailedException {
        int thresholdResolved = this.threshold(dimensions);
        Extent extent = object.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedByteBuffer buffer = object.sliceBufferLocal(z);
            VoxelBuffer bufferChannel = this.voxels.slice(z + object.boundingBox().cornerMin().z());
            for (int y = 0; y < extent.y(); ++y) {
                for (int x = 0; x < extent.x(); ++x) {
                    int offset = extent.offset(x, y);
                    if (buffer.getRaw(offset) != object.binaryValuesByte().getOn()) continue;
                    int y1 = y + object.boundingBox().cornerMin().y();
                    int x1 = x + object.boundingBox().cornerMin().x();
                    int offsetGlobal = this.voxels.extent().offset(x1, y1);
                    int val = bufferChannel.getInt(offsetGlobal);
                    if (val < thresholdResolved) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int threshold(Optional<Dimensions> dim) throws OperationFailedException {
        return (int)Math.ceil(this.threshold.resolveForAxis(dim.flatMap(Dimensions::unitConvert), Axis.X));
    }

    @Override
    protected void end() throws OperationFailedException {
        this.voxels = null;
    }

    @Generated
    public ChannelProvider getChannel() {
        return this.channel;
    }

    @Generated
    public void setChannel(ChannelProvider channel) {
        this.channel = channel;
    }

    @Generated
    public UnitValueDistance getThreshold() {
        return this.threshold;
    }

    @Generated
    public void setThreshold(UnitValueDistance threshold) {
        this.threshold = threshold;
    }
}

