/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.independent;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterPredicate;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class NotTouchingSceneBorder
extends ObjectFilterPredicate {
    @BeanField
    private boolean includeZ = false;

    @Override
    protected boolean precondition(ObjectCollection objectsToFilter) {
        return true;
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dimensions) throws OperationFailedException {
        if (!dimensions.isPresent()) {
            throw new OperationFailedException("Image-dimensions are required for this operation");
        }
        if (object.boundingBox().atBorderXY(dimensions.get().extent())) {
            return false;
        }
        if (this.includeZ) {
            ReadableTuple3i cornerMin = object.boundingBox().cornerMin();
            if (cornerMin.z() == 0) {
                return false;
            }
            ReadableTuple3i cornerMax = object.boundingBox().calculateCornerMaxInclusive();
            if (cornerMax.z() == dimensions.get().z() - 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void end() throws OperationFailedException {
    }

    @Generated
    public boolean isIncludeZ() {
        return this.includeZ;
    }

    @Generated
    public void setIncludeZ(boolean includeZ) {
        this.includeZ = includeZ;
    }
}

