/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.permute.assign.AssignPermutationException;
import org.anchoranalysis.bean.permute.assign.PermutationAssigner;
import org.anchoranalysis.bean.permute.property.PermuteProperty;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;

public class Permute
extends ObjectCollectionProvider {
    @BeanField
    private ObjectCollectionProvider objects;
    @BeanField
    private PermuteProperty<?> permuteProperty;

    public ObjectCollection get() throws ProvisionFailedException {
        try {
            PermutationAssigner ps = this.permuteProperty.createSetter((AnchorBean)this.objects);
            Iterator valuesToPermute = this.permuteProperty.propertyValues();
            if (!valuesToPermute.hasNext()) {
                throw new ProvisionFailedException("No values exist to assign during permutation.");
            }
            return this.createPermutedObjects(ps, Permute.streamFromIterator(valuesToPermute));
        }
        catch (AssignPermutationException e1) {
            throw new ProvisionFailedException("Cannot create a permutation setter", (Throwable)e1);
        }
    }

    private ObjectCollection createPermutedObjects(PermutationAssigner setter, Stream<?> propVals) throws ProvisionFailedException {
        return ObjectCollectionFactory.flatMapFrom(propVals, CreateException.class, propVal -> this.objectsForPermutation(setter, propVal));
    }

    private ObjectCollection objectsForPermutation(PermutationAssigner setter, Object propVal) throws ProvisionFailedException {
        ObjectCollectionProvider provider = (ObjectCollectionProvider)this.objects.duplicateBean();
        try {
            setter.assignValue((AnchorBean)provider, propVal);
        }
        catch (AssignPermutationException e) {
            throw new ProvisionFailedException("Cannot set permutation on an object-mask-provider", (Throwable)e);
        }
        try {
            provider.initializeRecursive((BeanInitialization)((ImageInitialization)this.getInitialization()), this.getLogger());
        }
        catch (InitializeException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
        return (ObjectCollection)provider.get();
    }

    private static <T> Stream<T> streamFromIterator(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    @Generated
    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    @Generated
    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }

    @Generated
    public PermuteProperty<?> getPermuteProperty() {
        return this.permuteProperty;
    }

    @Generated
    public void setPermuteProperty(PermuteProperty<?> permuteProperty) {
        this.permuteProperty = permuteProperty;
    }
}

