/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.scale.ScaledElements;
import org.anchoranalysis.image.core.object.scale.Scaler;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.plugin.image.bean.object.provider.WithDimensionsBase;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class Scale
extends WithDimensionsBase {
    @BeanField
    private ScaleCalculator scaleCalculator;

    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        Dimensions dimensions = this.createDimensions();
        ScaleFactor factor = this.calculateFactor(dimensions);
        return this.scaleObjects(objects, factor, dimensions.extent());
    }

    private ScaleFactor calculateFactor(Dimensions dimensions) throws ProvisionFailedException {
        try {
            return this.scaleCalculator.calculate(Optional.of(dimensions), ((ImageInitialization)this.getInitialization()).suggestedSize());
        }
        catch (InitializeException | OperationFailedException e) {
            throw new ProvisionFailedException(e);
        }
    }

    private ObjectCollection scaleObjects(ObjectCollection objects, ScaleFactor factor, Extent extent) throws ProvisionFailedException {
        try {
            ScaledElements scaledObjects = Scaler.scaleObjects((ObjectCollection)objects, (ScaleFactor)factor, (boolean)true, (Extent)extent);
            return ObjectCollectionFactory.of((Collection[])new Collection[]{scaledObjects.asCollectionOrderNotPreserved()});
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    @Generated
    public ScaleCalculator getScaleCalculator() {
        return this.scaleCalculator;
    }

    @Generated
    public void setScaleCalculator(ScaleCalculator scaleCalculator) {
        this.scaleCalculator = scaleCalculator;
    }
}

