/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.connected;

import lombok.Generated;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.nonbean.UnitValueException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.bean.unitvalue.extent.UnitValueExtent;
import org.anchoranalysis.image.bean.unitvalue.extent.volume.VolumeVoxels;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.apache.commons.lang.time.StopWatch;

public class ConnectedComponentsFromMask
extends ObjectCollectionProvider {
    @BeanField
    private Provider<Mask> mask;
    @BeanField
    private UnitValueExtent minVolume = new VolumeVoxels(1.0);
    @BeanField
    private boolean bySlices = false;
    @BeanField
    private boolean bigNeighborhood = false;

    public ObjectCollection get() throws ProvisionFailedException {
        Mask maskCreated = (Mask)this.mask.get();
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            int minNumberVoxels = (int)Math.round(this.minVolume.resolveToVoxels(maskCreated.dimensions().unitConvert()));
            if (this.bySlices) {
                return this.createObjectsBySlice(maskCreated, minNumberVoxels);
            }
            return this.createObjects3D(maskCreated, minNumberVoxels);
        }
        catch (UnitValueException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private ObjectsFromConnectedComponentsFactory createFactory(int minNumberVoxels) {
        return new ObjectsFromConnectedComponentsFactory(this.bigNeighborhood, minNumberVoxels);
    }

    private ObjectCollection createObjects3D(Mask mask, int minNumberVoxels) {
        return this.createFactory(minNumberVoxels).createUnsignedByte(mask.binaryVoxels());
    }

    private ObjectCollection createObjectsBySlice(Mask mask, int minNumberVoxels) {
        ObjectsFromConnectedComponentsFactory creator = this.createFactory(minNumberVoxels);
        VoxelsExtracter extracter = mask.voxels().extract();
        return ObjectCollectionFactory.flatMapFromRange((int)0, (int)mask.dimensions().z(), CreateException.class, z -> this.createForSlice(creator, ConnectedComponentsFromMask.extractSlice((VoxelsExtracter<UnsignedByteBuffer>)extracter, z, mask.binaryValuesInt()), z));
    }

    private static BinaryVoxels<UnsignedByteBuffer> extractSlice(VoxelsExtracter<UnsignedByteBuffer> extracter, int z, BinaryValuesInt binaryValues) {
        return BinaryVoxelsFactory.reuseByte((Voxels)extracter.slice(z), (BinaryValuesInt)binaryValues);
    }

    private ObjectCollection createForSlice(ObjectsFromConnectedComponentsFactory objectCreator, BinaryVoxels<UnsignedByteBuffer> binaryValues, int z) {
        return objectCreator.createUnsignedByte(binaryValues).stream().mapBoundingBoxPreserveExtent(box -> box.shiftToZ(z));
    }

    @Generated
    public Provider<Mask> getMask() {
        return this.mask;
    }

    @Generated
    public void setMask(Provider<Mask> mask) {
        this.mask = mask;
    }

    @Generated
    public UnitValueExtent getMinVolume() {
        return this.minVolume;
    }

    @Generated
    public void setMinVolume(UnitValueExtent minVolume) {
        this.minVolume = minVolume;
    }

    @Generated
    public boolean isBySlices() {
        return this.bySlices;
    }

    @Generated
    public void setBySlices(boolean bySlices) {
        this.bySlices = bySlices;
    }

    @Generated
    public boolean isBigNeighborhood() {
        return this.bigNeighborhood;
    }

    @Generated
    public void setBigNeighborhood(boolean bigNeighborhood) {
        this.bigNeighborhood = bigNeighborhood;
    }
}

