/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.feature;

import java.util.Optional;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.feature.ObjectCollectionProviderWithFeature;

public class ObjectWithMaximumFeature
extends ObjectCollectionProviderWithFeature {
    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        Optional<ObjectMask> max = this.findMaximum(this.createSession(), objects);
        if (max.isPresent()) {
            return ObjectCollectionFactory.of((ObjectMask[])new ObjectMask[]{max.get()});
        }
        return ObjectCollectionFactory.empty();
    }

    private Optional<ObjectMask> findMaximum(FeatureCalculatorSingle<FeatureInputSingleObject> session, ObjectCollection objects) throws ProvisionFailedException {
        try {
            ObjectMask max = null;
            double maxVal = 0.0;
            for (ObjectMask object : objects) {
                double featureVal = session.calculate((FeatureInput)new FeatureInputSingleObject(object));
                if (max != null && !(featureVal > maxVal)) continue;
                max = object;
                maxVal = featureVal;
            }
            return Optional.ofNullable(max);
        }
        catch (FeatureCalculationException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }
}

