/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.feature;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.bean.object.ObjectMatcher;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.feature.ObjectCollectionProviderWithFeature;

public class ObjectWithMaximumFeatureFromEachMatchedCollection
extends ObjectCollectionProviderWithFeature {
    @BeanField
    private ObjectMatcher matcher;

    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        FeatureCalculatorSingle<FeatureInputSingleObject> session = this.createSession();
        try {
            List listMatches = this.matcher.findMatch(objects);
            return ObjectCollectionFactory.mapFromOptional((Iterable)listMatches, FeatureCalculationException.class, owm -> this.findMax(session, owm.getMatches()));
        }
        catch (OperationFailedException | FeatureCalculationException e) {
            throw new ProvisionFailedException(e);
        }
    }

    private Optional<ObjectMask> findMax(FeatureCalculatorSingle<FeatureInputSingleObject> session, ObjectCollection objects) throws FeatureCalculationException {
        Optional<ObjectMask> max = Optional.empty();
        double maxVal = 0.0;
        for (ObjectMask objectMask : objects) {
            double featureVal = session.calculate((FeatureInput)new FeatureInputSingleObject(objectMask));
            if (max.isPresent() && !(featureVal > maxVal)) continue;
            max = Optional.of(objectMask);
            maxVal = featureVal;
        }
        return max;
    }

    @Generated
    public ObjectMatcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public void setMatcher(ObjectMatcher matcher) {
        this.matcher = matcher;
    }
}

