/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.feature;

import java.util.SortedSet;
import lombok.Generated;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.feature.ObjectCollectionProviderWithFeature;

public class SortByFeature
extends ObjectCollectionProviderWithFeature {
    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        try {
            FeatureCalculatorSingle<FeatureInputSingleObject> featureSession = this.createSession();
            SortedSet sorted = objects.stream().mapToSortedSet(objectMask -> new ObjectWithFeatureValue((ObjectMask)objectMask, featureSession.calculate((FeatureInput)new FeatureInputSingleObject(objectMask))));
            return ObjectCollectionFactory.mapFrom((Iterable)sorted, ObjectWithFeatureValue::getObject);
        }
        catch (FeatureCalculationException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static class ObjectWithFeatureValue
    implements Comparable<ObjectWithFeatureValue> {
        private final ObjectMask object;
        private final double featureVal;

        @Override
        public int compareTo(ObjectWithFeatureValue other) {
            return Double.compare(other.featureVal, this.featureVal);
        }

        @Generated
        public ObjectWithFeatureValue(ObjectMask object, double featureVal) {
            this.object = object;
            this.featureVal = featureVal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectWithFeatureValue)) {
                return false;
            }
            ObjectWithFeatureValue other = (ObjectWithFeatureValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.featureVal, other.featureVal) != 0) {
                return false;
            }
            ObjectMask this$object = this.getObject();
            ObjectMask other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ObjectWithFeatureValue;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $featureVal = Double.doubleToLongBits(this.featureVal);
            result = result * 59 + (int)($featureVal >>> 32 ^ $featureVal);
            ObjectMask $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }

        @Generated
        public ObjectMask getObject() {
            return this.object;
        }
    }
}

