/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.merge;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.plugin.image.bean.object.match.MatcherIntersectionHelper;
import org.anchoranalysis.plugin.image.bean.object.provider.WithContainerBase;

public abstract class MergeBase
extends WithContainerBase {
    @BeanField
    @OptionalBean
    private DimensionsProvider dimensions;

    protected Optional<UnitConverter> unitConvertOptional() throws OperationFailedException {
        return this.resolutionOptional().map(Resolution::unitConvert);
    }

    protected Resolution resolutionRequired() throws OperationFailedException {
        return this.resolutionOptional().orElseThrow(() -> new OperationFailedException("This algorithm requires an image-resolution to be set via resProvider"));
    }

    protected ObjectCollection mergeMultiplex(ObjectCollection objects, MergeObjects mergeFunc) throws OperationFailedException {
        ObjectCollection objectsToMerge = objects.duplicateShallow();
        try {
            Optional<ObjectCollection> container = this.containerOptional();
            if (container.isPresent()) {
                return MergeBase.mergeInContainer(mergeFunc, objectsToMerge, container.get());
            }
            return MergeBase.mergeAll(mergeFunc, objectsToMerge);
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Optional<Resolution> resolutionOptional() throws OperationFailedException {
        try {
            return OptionalProviderFactory.create((Provider)this.dimensions).flatMap(Dimensions::resolution);
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static ObjectCollection mergeAll(MergeObjects merger, ObjectCollection objects) throws OperationFailedException {
        return ObjectCollectionFactory.of((ObjectCollection[])new ObjectCollection[]{merger.mergeObjects(objects)});
    }

    private static ObjectCollection mergeInContainer(MergeObjects merger, ObjectCollection objects, ObjectCollection containerObjects) throws OperationFailedException {
        Stream<ObjectCollection> matchesStream = MatcherIntersectionHelper.matchIntersectingObjects(containerObjects, objects).stream().map(MatchedObject::getMatches);
        return ObjectCollectionFactory.flatMapFrom(matchesStream, OperationFailedException.class, merger::mergeObjects);
    }

    @Generated
    public DimensionsProvider getDimensions() {
        return this.dimensions;
    }

    @Generated
    public void setDimensions(DimensionsProvider dimensions) {
        this.dimensions = dimensions;
    }

    @FunctionalInterface
    protected static interface MergeObjects {
        public ObjectCollection mergeObjects(ObjectCollection var1) throws OperationFailedException;
    }
}

