/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.merge;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.relation.GreaterThanEqualToBean;
import org.anchoranalysis.bean.shared.relation.RelationBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingleChangeInput;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingleFromMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.feature.input.FeatureInputNull;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsFeatures;
import org.anchoranalysis.image.feature.calculator.merged.PairsTableCalculator;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.plugin.image.bean.object.provider.merge.MergeWithFeature;
import org.anchoranalysis.plugin.image.object.merge.PayloadCalculator;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriority;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriorityFromPair;

public class MergePairs
extends MergeWithFeature {
    @BeanField
    private FeatureEvaluator<FeatureInputNull> featureEvaluatorThreshold;
    @BeanField
    private RelationBean relation = new GreaterThanEqualToBean();
    @BeanField
    private FeatureEvaluator<FeatureInputPairObjects> featureEvaluatorMerge;

    @Override
    protected PayloadCalculator createPayloadCalculator() {
        return objectMask -> 0.0;
    }

    @Override
    protected AssignPriority createPrioritizer() throws OperationFailedException {
        try {
            double threshold = this.featureEvaluatorThreshold.createFeatureSession().calculate((FeatureInput)FeatureInputNull.instance());
            return new AssignPriorityFromPair(this.createCalculatorForPairs(), threshold, this.relation.create());
        }
        catch (CreateException | FeatureCalculationException e) {
            throw new OperationFailedException(e);
        }
    }

    @Override
    protected boolean isPlayloadUsed() {
        return true;
    }

    private FeatureCalculatorSingle<FeatureInputPairObjects> createCalculatorForPairs() throws CreateException {
        try {
            Optional energyStack = this.featureEvaluatorMerge.energyStack();
            FeatureList features = FeatureListFactory.from((Feature[])new Feature[]{this.featureEvaluatorMerge.getFeature()});
            PairsTableCalculator session = new PairsTableCalculator(new MergedPairsFeatures(features));
            session.start((ImageInitialization)this.getInitialization(), energyStack, this.getLogger());
            return MergePairs.maybeWrapWithEnergyStack(new FeatureCalculatorSingleFromMulti((FeatureCalculatorMulti)session), energyStack);
        }
        catch (InitializeException | OperationFailedException e) {
            throw new CreateException(e);
        }
    }

    private static <T extends FeatureInputEnergy> FeatureCalculatorSingle<T> maybeWrapWithEnergyStack(FeatureCalculatorSingle<T> calculator, Optional<EnergyStack> energyStack) {
        if (energyStack.isPresent()) {
            return new FeatureCalculatorSingleChangeInput(calculator, input -> input.setEnergyStack(energyStack));
        }
        return calculator;
    }

    @Generated
    public FeatureEvaluator<FeatureInputNull> getFeatureEvaluatorThreshold() {
        return this.featureEvaluatorThreshold;
    }

    @Generated
    public void setFeatureEvaluatorThreshold(FeatureEvaluator<FeatureInputNull> featureEvaluatorThreshold) {
        this.featureEvaluatorThreshold = featureEvaluatorThreshold;
    }

    @Generated
    public RelationBean getRelation() {
        return this.relation;
    }

    @Generated
    public void setRelation(RelationBean relation) {
        this.relation = relation;
    }

    @Generated
    public FeatureEvaluator<FeatureInputPairObjects> getFeatureEvaluatorMerge() {
        return this.featureEvaluatorMerge;
    }

    @Generated
    public void setFeatureEvaluatorMerge(FeatureEvaluator<FeatureInputPairObjects> featureEvaluatorMerge) {
        this.featureEvaluatorMerge = featureEvaluatorMerge;
    }
}

