/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.merge;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.graph.TypedEdge;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.plugin.image.bean.object.provider.merge.MergeWithOptionalDistanceConstraint;
import org.anchoranalysis.plugin.image.object.merge.MergeGraph;
import org.anchoranalysis.plugin.image.object.merge.ObjectVertex;
import org.anchoranalysis.plugin.image.object.merge.PayloadCalculator;
import org.anchoranalysis.plugin.image.object.merge.condition.AndCondition;
import org.anchoranalysis.plugin.image.object.merge.condition.NeighborhoodCondition;
import org.anchoranalysis.plugin.image.object.merge.condition.UpdatableBeforeCondition;
import org.anchoranalysis.plugin.image.object.merge.condition.WrapAsUpdatable;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriority;
import org.anchoranalysis.plugin.image.object.merge.priority.PrioritisedVertex;

public abstract class MergeWithFeature
extends MergeWithOptionalDistanceConstraint {
    @BeanField
    private boolean requireBBoxNeighbors = true;
    @BeanField
    private boolean requireTouching = true;

    public ObjectCollection createFromObjects(ObjectCollection objectsSource) throws ProvisionFailedException {
        this.getLogger().messageLogger().logFormatted("There are %d input objects", new Object[]{objectsSource.size()});
        try {
            ObjectCollection merged = this.mergeMultiplex(objectsSource, this::mergeConnectedComponents);
            this.getLogger().messageLogger().logFormatted("There are %d final objects", new Object[]{merged.size()});
            return merged;
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    protected abstract PayloadCalculator createPayloadCalculator() throws OperationFailedException;

    protected abstract AssignPriority createPrioritizer() throws OperationFailedException;

    protected abstract boolean isPlayloadUsed();

    private ObjectCollection mergeConnectedComponents(ObjectCollection objects) throws OperationFailedException {
        MergeGraph graph;
        MessageLogger logger = this.getLogger().messageLogger();
        try {
            graph = this.createGraph(objects, this.unitConvertOptional());
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
        logger.log("\nBefore");
        graph.logGraphDescription();
        while (this.tryMerge(graph)) {
        }
        logger.log("After");
        graph.logGraphDescription();
        return graph.verticesAsObjects();
    }

    private boolean tryMerge(MergeGraph graph) throws OperationFailedException {
        TypedEdge<ObjectVertex, PrioritisedVertex> edgeToMerge = graph.findMaxPriority();
        if (edgeToMerge == null) {
            return false;
        }
        graph.merge(edgeToMerge);
        return true;
    }

    private MergeGraph createGraph(ObjectCollection objects, Optional<UnitConverter> unitConverter) throws CreateException {
        try {
            MergeGraph graph = new MergeGraph(this.createPayloadCalculator(), this.beforeConditions(), unitConverter, this.createPrioritizer(), this.getLogger(), this.isPlayloadUsed());
            graph.addObjectsToGraph(objects);
            return graph;
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private UpdatableBeforeCondition beforeConditions() {
        return new AndCondition(new WrapAsUpdatable(this.maybeDistanceCondition()), new NeighborhoodCondition(this.requireBBoxNeighbors, this.requireTouching));
    }

    @Generated
    public boolean isRequireBBoxNeighbors() {
        return this.requireBBoxNeighbors;
    }

    @Generated
    public void setRequireBBoxNeighbors(boolean requireBBoxNeighbors) {
        this.requireBBoxNeighbors = requireBBoxNeighbors;
    }

    @Generated
    public boolean isRequireTouching() {
        return this.requireTouching;
    }

    @Generated
    public void setRequireTouching(boolean requireTouching) {
        this.requireTouching = requireTouching;
    }
}

