/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.segment;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.UnaryWithChannelBase;

public class BinarySegmentByObject
extends UnaryWithChannelBase {
    @BeanField
    private BinarySegmentation binarySgmn;

    @Override
    protected ObjectCollection createFromObjects(ObjectCollection objectsSource, Channel channelSource) throws ProvisionFailedException {
        try {
            return objectsSource.stream().map(object -> this.sgmnObject((ObjectMask)object, channelSource));
        }
        catch (SegmentationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private ObjectMask sgmnObject(ObjectMask object, Channel channelSource) throws SegmentationFailedException {
        Voxels voxels = channelSource.extract().region(object.boundingBox(), true);
        BinaryVoxels binaryValues = this.binarySgmn.segment(new VoxelsUntyped(voxels), new BinarySegmentationParameters(), Optional.of(new ObjectMask(object.voxels())));
        return new ObjectMask(object.boundingBox(), binaryValues);
    }

    @Generated
    public BinarySegmentation getBinarySgmn() {
        return this.binarySgmn;
    }

    @Generated
    public void setBinarySgmn(BinarySegmentation binarySgmn) {
        this.binarySgmn = binarySgmn;
    }
}

