/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.segment;

import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class SeedsFactory {
    public static ObjectCollection createSeedsWithoutMask(ObjectCollection seeds) {
        return seeds.stream().map(SeedsFactory::createSeed);
    }

    public static ObjectCollection createSeedsWithMask(ObjectCollection seeds, ObjectMask containingMask, ReadableTuple3i subtractFromCornerMin, Dimensions dim) throws CreateException {
        return seeds.stream().map(object -> SeedsFactory.createSeedWithinMask(object, containingMask.boundingBox(), subtractFromCornerMin, dim));
    }

    private static ObjectMask createSeed(ObjectMask object) {
        return object.duplicate();
    }

    private static ObjectMask createSeedWithinMask(ObjectMask object, BoundingBox containingBBox, ReadableTuple3i subtractFromCornerMin, Dimensions dim) throws CreateException {
        ObjectMask seed = object.shiftBackBy(subtractFromCornerMin);
        return SeedsFactory.ensureInsideContainer(seed, containingBBox, dim);
    }

    private static ObjectMask ensureInsideContainer(ObjectMask seed, BoundingBox containingBBox, Dimensions dimensions) throws CreateException {
        if (!containingBBox.contains().box(seed.boundingBox())) {
            BoundingBox boxIntersect = (BoundingBox)containingBBox.intersection().withInside(seed.boundingBox(), dimensions.extent()).orElseThrow(() -> new CreateException("No bounding box intersection exists between seed and containing bounding-box"));
            return seed.region(boxIntersect, false);
        }
        return seed;
    }

    @Generated
    private SeedsFactory() {
    }
}

