/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.segment;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.WithChannelBase;
import org.anchoranalysis.plugin.image.bean.object.provider.segment.SeedsFactory;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class SegmentChannel
extends WithChannelBase {
    @BeanField
    @OptionalBean
    private MaskProvider mask;
    @BeanField
    private SegmentChannelIntoObjects segment;
    @BeanField
    @OptionalBean
    private ObjectCollectionProvider objectsSeeds;

    @Override
    protected ObjectCollection createFromChannel(Channel channelSource) throws ProvisionFailedException {
        Optional<ObjectMask> maskAsObject = this.createObjectMask();
        try {
            return this.segment.segment(channelSource, maskAsObject, this.createSeeds(channelSource.dimensions(), maskAsObject));
        }
        catch (SegmentationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private Optional<ObjectMask> createObjectMask() throws ProvisionFailedException {
        return OptionalProviderFactory.create((Provider)this.mask).map(Mask::binaryVoxels).map(ObjectMask::new);
    }

    private Optional<ObjectCollection> createSeeds(Dimensions dimensions, Optional<ObjectMask> maskAsObject) throws ProvisionFailedException {
        return OptionalUtilities.map((Optional)OptionalProviderFactory.create((Provider)this.objectsSeeds), objects -> SegmentChannel.createSeeds(objects, maskAsObject, dimensions));
    }

    private static ObjectCollection createSeeds(ObjectCollection seeds, Optional<ObjectMask> maskAsObject, Dimensions dimensions) throws ProvisionFailedException {
        try {
            return OptionalUtilities.map(maskAsObject, object -> SeedsFactory.createSeedsWithMask(seeds, object, (ReadableTuple3i)new Point3i(0, 0, 0), dimensions)).orElseGet(() -> SeedsFactory.createSeedsWithoutMask(seeds));
        }
        catch (CreateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    @Generated
    public MaskProvider getMask() {
        return this.mask;
    }

    @Generated
    public void setMask(MaskProvider mask) {
        this.mask = mask;
    }

    @Generated
    public SegmentChannelIntoObjects getSegment() {
        return this.segment;
    }

    @Generated
    public void setSegment(SegmentChannelIntoObjects segment) {
        this.segment = segment;
    }

    @Generated
    public ObjectCollectionProvider getObjectsSeeds() {
        return this.objectsSeeds;
    }

    @Generated
    public void setObjectsSeeds(ObjectCollectionProvider objectsSeeds) {
        this.objectsSeeds = objectsSeeds;
    }
}

