/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.slice;

import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

class ExtendObjectsInZHelper {
    public static ObjectMask createExtendedObject(ObjectMask flat, ObjectMask container, BoundingBox box, int zCenter) throws CreateException {
        Extent extent = box.extent();
        ObjectMask objectNew = container.region(box, false);
        UnsignedByteBuffer bufferFlat = flat.sliceBufferLocal(0);
        int zLow = box.cornerMin().z();
        int zHigh = box.calculateCornerMaxInclusive().z();
        if (zCenter > zHigh) {
            zCenter = zHigh;
        }
        if (zCenter < zLow) {
            zCenter = zLow;
        }
        ExtendObjectsInZHelper.extend(bufferFlat, extent, objectNew, flat, zLow, IntStream.range(zCenter, zHigh + 1));
        ExtendObjectsInZHelper.extend(bufferFlat, extent, objectNew, flat, zLow, ExtendObjectsInZHelper.revRange(zLow, zCenter));
        return objectNew;
    }

    private static boolean extend(UnsignedByteBuffer bufferFlat, Extent extent, ObjectMask objectNew, ObjectMask flat, int zLow, IntStream zRange) {
        boolean andMode = true;
        boolean writtenOneSlice = false;
        int volumeXY = extent.areaXY();
        PrimitiveIterator.OfInt itr = zRange.iterator();
        while (itr.hasNext()) {
            int z = (Integer)itr.next();
            int zRel = z - zLow;
            UnsignedByteBuffer bufferExisting = objectNew.sliceBufferLocal(zRel);
            if (andMode) {
                if (ExtendObjectsInZHelper.bufferLogicalAnd(volumeXY, bufferExisting, bufferFlat, objectNew.binaryValuesByte(), flat.binaryValuesByte())) {
                    writtenOneSlice = true;
                    continue;
                }
                if (!writtenOneSlice) continue;
                andMode = false;
                continue;
            }
            ExtendObjectsInZHelper.setBufferLow(extent.areaXY(), bufferExisting, objectNew.binaryValuesByte());
        }
        return writtenOneSlice;
    }

    private static void setBufferLow(int numVoxels, UnsignedByteBuffer buffer, BinaryValuesByte binaryValues) {
        for (int i = 0; i < numVoxels; ++i) {
            buffer.putRaw(i, binaryValues.getOff());
        }
    }

    private static boolean bufferLogicalAnd(int numberVoxels, UnsignedByteBuffer buffer, UnsignedByteBuffer receive, BinaryValuesByte binaryValues, BinaryValuesByte binaryValuesReceive) {
        boolean atLeastOneHigh = false;
        for (int i = 0; i < numberVoxels; ++i) {
            byte byteBuffer = buffer.getRaw(i);
            byte byteReceive = receive.getRaw(i);
            if (byteBuffer == binaryValues.getOn() && byteReceive == binaryValuesReceive.getOn()) {
                atLeastOneHigh = true;
                continue;
            }
            buffer.putRaw(i, binaryValues.getOff());
        }
        return atLeastOneHigh;
    }

    private static IntStream revRange(int from, int to) {
        return IntStream.range(from, to).map(i -> to - i + from - 1);
    }

    @Generated
    private ExtendObjectsInZHelper() {
    }
}

