/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class ConnectedComponentsFromBinarySegmentation
extends SegmentChannelIntoObjects {
    @BeanField
    private BinarySegmentation segment;
    @BeanField
    private int minNumberVoxels = 1;

    public ObjectCollection segment(Channel channel, Optional<ObjectMask> objectMask, Optional<ObjectCollection> seeds) throws SegmentationFailedException {
        BinarySegmentationParameters parameters = new BinarySegmentationParameters(channel.resolution());
        BinaryVoxels binaryValues = this.segment.segment(channel.voxels(), parameters, objectMask);
        return this.createFromVoxels((BinaryVoxels<UnsignedByteBuffer>)binaryValues, channel.resolution(), objectMask.map(object -> object.boundingBox().cornerMin()));
    }

    private ObjectCollection createFromVoxels(BinaryVoxels<UnsignedByteBuffer> binaryValues, Optional<Resolution> resolution, Optional<ReadableTuple3i> maskShiftBy) {
        Mask mask = new Mask(binaryValues, resolution);
        ObjectsFromConnectedComponentsFactory creator = new ObjectsFromConnectedComponentsFactory(this.minNumberVoxels);
        return ConnectedComponentsFromBinarySegmentation.maybeShiftObjects(creator.createUnsignedByte(mask.binaryVoxels()), maskShiftBy);
    }

    private static ObjectCollection maybeShiftObjects(ObjectCollection objects, Optional<ReadableTuple3i> shiftByQuantity) {
        return shiftByQuantity.map(arg_0 -> ((ObjectCollection)objects).shiftBy(arg_0)).orElse(objects);
    }

    @Generated
    public BinarySegmentation getSegment() {
        return this.segment;
    }

    @Generated
    public void setSegment(BinarySegmentation segment) {
        this.segment = segment;
    }

    @Generated
    public int getMinNumberVoxels() {
        return this.minNumberVoxels;
    }

    @Generated
    public void setMinNumberVoxels(int minNumberVoxels) {
        this.minNumberVoxels = minNumberVoxels;
    }
}

