/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.mask.MaskFromObjects;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.MinimaImposition;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.grayscalereconstruction.GrayscaleReconstructionByErosion;
import org.anchoranalysis.spatial.box.Extent;

public class MinimaImpositionGrayscaleReconstruction
extends MinimaImposition {
    @BeanField
    private GrayscaleReconstructionByErosion grayscaleReconstruction;

    @Override
    public Channel imposeMinima(Channel channel, ObjectCollection seeds, Optional<ObjectMask> containingMask) throws OperationFailedException {
        if (seeds.size() < 1) {
            throw new OperationFailedException("There must be at least one seed");
        }
        MinimaImpositionGrayscaleReconstruction.verifySeedsAreInside(seeds, channel.extent());
        Mask markerMask = MaskFromObjects.createFromObjects((ObjectCollection)seeds, (Dimensions)channel.dimensions(), (BinaryValuesInt)seeds.getFirstBinaryValues());
        channel = channel.duplicate();
        VoxelsUntyped voxelsIntensity = channel.voxels();
        VoxelsAssigner zeroAssigner = voxelsIntensity.assignValue(0);
        seeds.forEach(arg_0 -> ((VoxelsAssigner)zeroAssigner).toObject(arg_0));
        if (containingMask.isPresent()) {
            voxelsIntensity.any().assignValue((int)voxelsIntensity.getVoxelDataType().maxValue()).toObject(containingMask.get());
        }
        VoxelsUntyped markerForReconstruction = this.createMarkerImageFromGradient(markerMask, voxelsIntensity);
        VoxelsUntyped reconBuffer = this.grayscaleReconstruction.reconstruction(voxelsIntensity, markerForReconstruction, containingMask);
        return ChannelFactory.instance().create(reconBuffer.any(), channel.resolution());
    }

    private VoxelsUntyped createMarkerImageFromGradient(Mask marker, VoxelsUntyped gradientImage) {
        VoxelsUntyped out = VoxelsFactory.instance().createEmpty(gradientImage.any().extent(), gradientImage.getVoxelDataType());
        out.assignValue((int)gradientImage.getVoxelDataType().maxValue()).toAll();
        ObjectMask object = new ObjectMask(marker.binaryVoxels());
        gradientImage.copyVoxelsTo(object, out, object.boundingBox());
        return out;
    }

    private static boolean verifySeedsAreInside(ObjectCollection seeds, Extent extent) {
        for (ObjectMask object : seeds) {
            if (extent.contains(object.boundingBox())) continue;
            return false;
        }
        return true;
    }

    @Generated
    public GrayscaleReconstructionByErosion getGrayscaleReconstruction() {
        return this.grayscaleReconstruction;
    }

    @Generated
    public void setGrayscaleReconstruction(GrayscaleReconstructionByErosion grayscaleReconstruction) {
        this.grayscaleReconstruction = grayscaleReconstruction;
    }
}

