/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.grayscalereconstruction;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.iterator.neighbor.IterateVoxelsNeighbors;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsolute;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborFactory;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferBinaryMixed;
import org.anchoranalysis.image.voxel.neighborhood.Neighborhood;
import org.anchoranalysis.image.voxel.neighborhood.NeighborhoodFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.grayscalereconstruction.GrayscaleReconstructionByErosion;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.grayscalereconstruction.PointProcessor;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.PriorityQueueIndexRangeDownhill;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class GrayscaleReconstructionRobinson
extends GrayscaleReconstructionByErosion {
    private static final byte OUT_ON = BinaryValuesByte.getDefault().getOn();

    @Override
    public VoxelsUntyped reconstruction(VoxelsUntyped mask, VoxelsUntyped marker, Optional<ObjectMask> containingMask) {
        marker.subtractFromMaxValue();
        mask.subtractFromMaxValue();
        VoxelsUntyped reconstructed = new VoxelsUntyped(this.reconstructionByDilation(mask, marker.any(), containingMask));
        reconstructed.subtractFromMaxValue();
        return reconstructed;
    }

    private <T> Voxels<?> reconstructionByDilation(VoxelsUntyped mask, Voxels<T> marker, Optional<ObjectMask> containingMask) {
        Voxels voxelsFinalized = VoxelsFactory.getUnsignedByte().createInitialized(marker.extent());
        int maxValue = (int)marker.extract().voxelWithMaxIntensity();
        PriorityQueueIndexRangeDownhill<Point3i> queue = new PriorityQueueIndexRangeDownhill<Point3i>(maxValue);
        VoxelProcessor processor = new VoxelProcessor(queue, OUT_ON);
        if (containingMask.isPresent()) {
            IterateVoxelsObjectMask.withTwoMixedBuffers((ObjectMask)containingMask.get(), marker, (Voxels)voxelsFinalized, processor);
        } else {
            IterateVoxelsAll.withTwoMixedBuffers(marker, (Voxels)voxelsFinalized, processor);
        }
        this.readFromQueueUntilEmpty(queue, marker, mask.any(), (Voxels<UnsignedByteBuffer>)voxelsFinalized, containingMask);
        return marker;
    }

    private void readFromQueueUntilEmpty(PriorityQueueIndexRangeDownhill<Point3i> queue, Voxels<?> voxelsMarker, Voxels<?> voxelsMask, Voxels<UnsignedByteBuffer> voxelsFinalized, Optional<ObjectMask> containingMask) {
        Extent extent = voxelsMarker.extent();
        SlidingBuffer bufferMarker = new SlidingBuffer(voxelsMarker);
        SlidingBuffer bufferMask = new SlidingBuffer(voxelsMask);
        SlidingBuffer bufferFinalized = new SlidingBuffer(voxelsFinalized);
        BinaryValuesByte binaryValuesFinalized = BinaryValuesByte.getDefault();
        ProcessVoxelNeighbor process = ProcessVoxelNeighborFactory.within(containingMask, (Extent)extent, (ProcessVoxelNeighborAbsolute)new PointProcessor(bufferMarker, bufferMask, (SlidingBuffer<UnsignedByteBuffer>)bufferFinalized, queue, binaryValuesFinalized));
        Neighborhood neighborhood = NeighborhoodFactory.of((boolean)false);
        boolean do3D = extent.z() > 1;
        int nextVal = queue.nextValue();
        while (nextVal != -1) {
            Point3i point = queue.get();
            bufferMarker.seek(point.z());
            bufferMask.seek(point.z());
            bufferFinalized.seek(point.z());
            IterateVoxelsNeighbors.callEachPointInNeighborhood((Point3i)point, (Neighborhood)neighborhood, (boolean)do3D, (ProcessVoxelNeighbor)process, (int)nextVal, (int)extent.offsetSlice((ReadableTuple3i)point));
            nextVal = queue.nextValue();
        }
    }

    private static class VoxelProcessor<T>
    implements ProcessVoxelBufferBinaryMixed<T, UnsignedByteBuffer> {
        private final PriorityQueueIndexRangeDownhill<Point3i> queue;
        private final byte maskOn;

        public void process(Point3i point, VoxelBuffer<T> buffer1, UnsignedByteBuffer buffer2, int offset) {
            int value = buffer1.getInt(offset);
            if (value != 0) {
                this.queue.put(point, value);
                buffer2.putRaw(offset, this.maskOn);
            }
        }

        @Generated
        public VoxelProcessor(PriorityQueueIndexRangeDownhill<Point3i> queue, byte maskOn) {
            this.queue = queue;
            this.maskOn = maskOn;
        }
    }
}

