/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.minima.grayscalereconstruction;

import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsoluteWithSlidingBuffer;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.PriorityQueueIndexRangeDownhill;
import org.anchoranalysis.spatial.point.Point3i;

class PointProcessor
extends ProcessVoxelNeighborAbsoluteWithSlidingBuffer<Object> {
    private SlidingBuffer<?> slidingBufferMask;
    private SlidingBuffer<UnsignedByteBuffer> slidingBufferFinalized;
    private PriorityQueueIndexRangeDownhill<Point3i> queue;
    private VoxelBuffer<?> bufferMask;
    private VoxelBuffer<UnsignedByteBuffer> bufferFinalized;
    private int z = 0;
    private final BinaryValuesByte binaryValues;

    public PointProcessor(SlidingBuffer<?> slidingBufferMarker, SlidingBuffer<?> slidingBufferMask, SlidingBuffer<UnsignedByteBuffer> slidingBufferFinalized, PriorityQueueIndexRangeDownhill<Point3i> queue, BinaryValuesByte binaryValues) {
        super(slidingBufferMarker);
        this.slidingBufferFinalized = slidingBufferFinalized;
        this.slidingBufferMask = slidingBufferMask;
        this.queue = queue;
        this.binaryValues = binaryValues;
    }

    public void notifyChangeZ(int zChange, int z) {
        super.notifyChangeZ(zChange, z);
        this.bufferMask = this.slidingBufferMask.bufferRelative(zChange);
        this.bufferFinalized = this.slidingBufferFinalized.bufferRelative(zChange);
        this.z = z;
    }

    public void processPoint(int xChange, int yChange, int x1, int y1) {
        int index = this.changedOffset(xChange, yChange);
        byte value = ((UnsignedByteBuffer)this.bufferFinalized.buffer()).getRaw(index);
        if (value == this.binaryValues.getOff()) {
            int maskVal = this.bufferMask.getInt(index);
            int valToWrite = Math.min(maskVal, this.sourceValue);
            this.putInt(index, valToWrite);
            this.queue.put(new Point3i(x1, y1, this.z), valToWrite);
            ((UnsignedByteBuffer)this.bufferFinalized.buffer()).putRaw(index, this.binaryValues.getOn());
        }
    }

    public Integer collectResult() {
        return -1;
    }
}

