/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.PointWithNeighbor;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class EqualVoxelsPlateau {
    private List<PointWithNeighbor> pointsEdge = new LinkedList<PointWithNeighbor>();
    private List<Point3i> pointsInner = new ArrayList<Point3i>();

    EqualVoxelsPlateau() {
    }

    public void addEdge(Point3i point, int neighborIndex) {
        Preconditions.checkArgument((neighborIndex >= 0 ? 1 : 0) != 0);
        this.pointsEdge.add(new PointWithNeighbor(point, neighborIndex));
    }

    public void addInner(Point3i point) {
        this.pointsInner.add(new Point3i((ReadableTuple3i)point));
    }

    public boolean hasPoints() {
        return !this.pointsEdge.isEmpty() || !this.pointsInner.isEmpty();
    }

    public boolean isOnlyEdge() {
        return this.pointsInner.isEmpty() && !this.pointsEdge.isEmpty();
    }

    public boolean isOnlyInner() {
        return this.pointsEdge.isEmpty() && !this.pointsInner.isEmpty();
    }

    public List<Point3i> pointsEdge() {
        return FunctionalList.mapToList(this.pointsEdge, PointWithNeighbor::getPoint);
    }

    public boolean hasNullItems() {
        for (Point3i point : this.pointsInner) {
            if (point != null) continue;
            return true;
        }
        for (PointWithNeighbor pointWithNeighbor : this.pointsEdge) {
            if (pointWithNeighbor != null) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.pointsEdge.size() + this.pointsInner.size();
    }

    @Generated
    public List<PointWithNeighbor> getPointsEdge() {
        return this.pointsEdge;
    }

    @Generated
    public List<Point3i> getPointsInner() {
        return this.pointsInner;
    }
}

