/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.IterateVoxelsNeighbors;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessChangedPointAbsoluteMasked;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborFactory;
import org.anchoranalysis.image.voxel.neighborhood.Neighborhood;
import org.anchoranalysis.image.voxel.neighborhood.NeighborhoodFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.CreateObjectFromPoints;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.EqualVoxelsPlateau;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.MinimaStore;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.PointWithNeighbor;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedVoxels;
import org.anchoranalysis.spatial.point.Point3i;

class MakePlateauLowerComplete {
    private EqualVoxelsPlateau plateau;
    private boolean do3D;

    public MakePlateauLowerComplete(EqualVoxelsPlateau plateau, boolean do3D) {
        this.plateau = plateau;
        this.do3D = do3D;
    }

    public void makeBufferLowerCompleteForPlateau(EncodedVoxels matS, Optional<MinimaStore> minimaStore) {
        assert (this.plateau.hasPoints());
        if (this.plateau.isOnlyEdge()) {
            this.pointEdgeToNeighboring(matS);
        } else if (this.plateau.isOnlyInner()) {
            assert (this.plateau.getPointsInner().size() >= 2);
            matS.pointListAtFirstPoint(this.plateau.getPointsInner());
            if (minimaStore.isPresent()) {
                minimaStore.get().add(this.plateau.getPointsInner());
            }
        } else {
            this.pointEdgeToNeighboring(matS);
            this.pointInnerToEdge(matS);
        }
    }

    private void pointEdgeToNeighboring(EncodedVoxels matS) {
        for (PointWithNeighbor pointNeighbor : this.plateau.getPointsEdge()) {
            matS.setPoint(pointNeighbor.getPoint(), pointNeighbor.getNeighborIndex());
        }
    }

    private void pointInnerToEdge(EncodedVoxels matS) {
        block3: {
            List<Point3i> searchPoints = this.plateau.pointsEdge();
            try {
                ObjectMask object = CreateObjectFromPoints.create(this.plateau.getPointsInner());
                Neighborhood neighborhood = NeighborhoodFactory.of((boolean)true);
                ProcessVoxelNeighbor process = ProcessVoxelNeighborFactory.withinMask((ObjectMask)object, (ProcessChangedPointAbsoluteMasked)new PointEvaluator(matS, object.binaryValuesByte()));
                while (!searchPoints.isEmpty()) {
                    searchPoints = this.findPointsFor(searchPoints, neighborhood, (ProcessVoxelNeighbor<List<Point3i>>)process);
                }
            }
            catch (CreateException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private List<Point3i> findPointsFor(List<Point3i> points, Neighborhood neighborhood, ProcessVoxelNeighbor<List<Point3i>> process) {
        ArrayList<Point3i> foundPoints = new ArrayList<Point3i>();
        for (Point3i point : points) {
            foundPoints.addAll((Collection)IterateVoxelsNeighbors.callEachPointInNeighborhood((Point3i)point, (Neighborhood)neighborhood, (boolean)this.do3D, process, (int)-1, (int)-1));
        }
        return foundPoints;
    }

    private static class PointEvaluator
    implements ProcessChangedPointAbsoluteMasked<List<Point3i>> {
        private final EncodedVoxels matS;
        private final List<Point3i> foundPoints = new ArrayList<Point3i>();
        private int zChange;
        private UnsignedByteBuffer buffer;
        private int z1;
        private final byte maskValueOff;

        public PointEvaluator(EncodedVoxels matS, BinaryValuesByte binaryValues) {
            this.matS = matS;
            this.maskValueOff = binaryValues.getOff();
        }

        public void initSource(int sourceValue, int sourceOffsetXY) {
            this.foundPoints.clear();
        }

        public void notifyChangeZ(int zChange, int z1, UnsignedByteBuffer objectMaskBuffer) {
            this.buffer = objectMaskBuffer;
            this.zChange = zChange;
            this.z1 = z1;
        }

        public void processPoint(int xChange, int yChange, int x, int y, int objectMaskOffset) {
            Point3i pointRel = new Point3i(x, y, this.z1);
            this.foundPoints.add(pointRel);
            this.buffer.putRaw(objectMaskOffset, this.maskValueOff);
            this.matS.setPointDirection(pointRel, xChange * -1, yChange * -1, this.zChange * -1);
        }

        public List<Point3i> collectResult() {
            return this.foundPoints;
        }
    }
}

