/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import lombok.Generated;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.SlidingBufferPlus;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedIntBuffer;
import org.anchoranalysis.spatial.point.Point3i;

final class PointPixelsOrMarkAsMinima
implements ProcessPoint {
    private final SlidingBufferPlus bufferPlus;
    private EncodedIntBuffer bufferS;

    public void notifyChangeSlice(int z) {
        this.bufferS = this.bufferPlus.getSPlane(z);
    }

    public void process(Point3i point) {
        int indxBuffer = this.bufferPlus.offsetSlice(point);
        if (!this.bufferS.isUnvisited(indxBuffer)) {
            return;
        }
        int gVal = this.bufferPlus.getG(indxBuffer);
        int chainCode = this.bufferPlus.steepestDescent(point, gVal, indxBuffer);
        if (this.bufferPlus.isMinima(chainCode)) {
            this.bufferS.putCode(indxBuffer, chainCode);
            this.bufferPlus.maybeAddMinima(point);
        } else if (this.bufferPlus.isPlateau(chainCode)) {
            this.bufferPlus.makePlateauAt(point);
        } else {
            this.bufferS.putCode(indxBuffer, chainCode);
        }
    }

    @Generated
    public PointPixelsOrMarkAsMinima(SlidingBufferPlus bufferPlus) {
        this.bufferPlus = bufferPlus;
    }
}

