/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import java.util.Optional;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.FindEqualVoxels;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.MakePlateauLowerComplete;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.MinimaStore;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedIntBuffer;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedVoxels;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.Steepest;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

final class SlidingBufferPlus {
    private final Steepest steepest;
    private final SlidingBuffer<?> slidingBufferSteepest;
    private final FindEqualVoxels findEqualVoxels;
    private final EncodedVoxels matS;
    private final Optional<MinimaStore> minimaStore;

    public SlidingBufferPlus(Voxels<?> voxelsImg, EncodedVoxels matS, Optional<ObjectMask> objectMask, Optional<MinimaStore> minimaStore) {
        this.matS = matS;
        this.minimaStore = minimaStore;
        this.slidingBufferSteepest = new SlidingBuffer(voxelsImg);
        boolean do3D = voxelsImg.extent().z() > 1;
        this.findEqualVoxels = new FindEqualVoxels(voxelsImg, matS, do3D, objectMask);
        this.steepest = new Steepest(this.slidingBufferSteepest, EncodedVoxels.ENCODING, do3D, true, objectMask);
    }

    public SlidingBuffer<?> getSlidingBuffer() {
        return this.slidingBufferSteepest;
    }

    public int offsetSlice(Point3i point) {
        return this.slidingBufferSteepest.extent().offsetSlice((ReadableTuple3i)point);
    }

    public int getG(int indxBuffer) {
        return this.slidingBufferSteepest.getCenter().getInt(indxBuffer);
    }

    public EncodedIntBuffer getSPlane(int z) {
        return this.matS.getPixelsForPlane(z);
    }

    public void maybeAddMinima(Point3i point) {
        if (this.minimaStore.isPresent()) {
            this.minimaStore.get().addDuplicated(point);
        }
    }

    public void makePlateauAt(Point3i point) {
        new MakePlateauLowerComplete(this.findEqualVoxels.createPlateau(point), this.findEqualVoxels.isDo3D()).makeBufferLowerCompleteForPlateau(this.matS, this.minimaStore);
    }

    public int steepestDescent(Point3i point, int val, int indxBuffer) {
        return this.steepest.steepestDescent(point, val, indxBuffer);
    }

    public boolean isPlateau(int code) {
        return this.matS.isPlateau(code);
    }

    public boolean isMinima(int code) {
        return this.matS.isMinima(code);
    }
}

