/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.reduce;

import java.util.List;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import org.anchoranalysis.image.inference.segment.WithConfidence;

class ConfidenceScaler<T> {
    private static final int MAX_RANGE_INT_MINUS = 254;
    private double minConfidence;
    private double spread;

    public ConfidenceScaler(double minConfidence, double maxConfidence) {
        this.minConfidence = minConfidence;
        this.spread = Math.max(maxConfidence - minConfidence, 1.0E-6);
    }

    public ConfidenceScaler(List<WithConfidence<T>> elements) {
        this(ConfidenceScaler.aggregateFunction(elements, DoubleStream::min), ConfidenceScaler.aggregateFunction(elements, DoubleStream::max));
    }

    public int downscale(double confidence) {
        double ratio = (confidence - this.minConfidence) / this.spread;
        return 1 + (int)(ratio * 254.0);
    }

    public double upscale(double unsignedByteValue) {
        double ratio = (unsignedByteValue - 1.0) / 254.0 * this.spread;
        return ratio + this.minConfidence;
    }

    private static <T> double aggregateFunction(List<WithConfidence<T>> list, Function<DoubleStream, OptionalDouble> aggregateFunction) {
        DoubleStream stream = list.stream().mapToDouble(WithConfidence::getConfidence);
        return aggregateFunction.apply(stream).getAsDouble();
    }
}

