/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.reduce;

import java.util.Iterator;
import java.util.List;
import java.util.function.DoubleToIntFunction;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.CalculateLevel;
import org.anchoranalysis.image.bean.threshold.ThresholderGlobal;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.histogram.threshold.Constant;
import org.anchoranalysis.plugin.image.bean.object.segment.reduce.ConfidenceScaler;
import org.anchoranalysis.plugin.image.bean.object.segment.reduce.DeriveObjectsFromMask;
import org.anchoranalysis.spatial.box.BoundingBox;

class DeriveObjectsFromStream {
    public static List<WithConfidence<ObjectMask>> deriveObjects(Stream<WithConfidence<ObjectMask>> elements, BoundingBox containingBox, double minConfidence, int minNumberVoxels) throws OperationFailedException {
        ConfidenceScaler scaler = new ConfidenceScaler(minConfidence, 1.0);
        Channel channel = DeriveObjectsFromStream.writeConfidenceIntoChannel(elements, containingBox, scaler::downscale);
        Mask mask = DeriveObjectsFromStream.threshold(channel.duplicate(), minConfidence, scaler::downscale);
        return DeriveObjectsFromMask.splitIntoObjects(mask, channel, scaler::upscale, containingBox.cornerMin(), minNumberVoxels);
    }

    private static Mask threshold(Channel channel, double minConfidence, DoubleToIntFunction convertConfidence) throws OperationFailedException {
        int minConfidenceNormalized = Math.max(convertConfidence.applyAsInt(minConfidence), 1);
        ThresholderGlobal thresholder = new ThresholderGlobal((CalculateLevel)new Constant(minConfidenceNormalized));
        return new Mask(thresholder.threshold(channel.voxels()));
    }

    private static Channel writeConfidenceIntoChannel(Stream<WithConfidence<ObjectMask>> elements, BoundingBox boxOverall, DoubleToIntFunction convertConfidence) {
        Dimensions dimensions = new Dimensions(boxOverall.extent());
        Channel channel = ((ChannelFactorySingleType)ChannelFactory.instance().get((VoxelDataType)UnsignedByteVoxelType.INSTANCE)).createEmptyInitialised(dimensions);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            WithConfidence element = (WithConfidence)iterator.next();
            int confidenceAsInt = convertConfidence.applyAsInt(element.getConfidence());
            channel.assignValue(confidenceAsInt).toObjectIf(((ObjectMask)element.getElement()).relativeMaskTo(boxOverall), voxelValue -> voxelValue == 0 || voxelValue > confidenceAsInt);
        }
        return channel;
    }

    @Generated
    private DeriveObjectsFromStream() {
    }
}

